/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListRowContent;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertListValueRowItem
extends ExpertListRowContent {
    private LogicModelItem logicModelItem;
    private final AbstractConverter converter;
    private final String logicModelItemName;

    public ExpertListValueRowItem(String logicModelItemName, AbstractConverter converter) {
        super(null, 8, true);
        this.logicModelItemName = logicModelItemName;
        this.converter = converter;
    }

    public List<ExpertDisplayModelItem> getChildren() {
        return Collections.emptyList();
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        this.logicModelItem = logicModelItems.get(this.logicModelItemName);
        if (this.logicModelItem == null) {
            throw new InvalidModelException("invalid item reference (" + this.logicModelItemName + ") in " + this.getClass().getName());
        }
    }

    public List<ExpertDisplayInfoDTO.ListDTO.ValueRowDTO> getRowDTOs(ExpertDisplayModel.RequestContext requestContext) {
        ModelItemDTO miDTO;
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        OptionItemsDTO optionItems = null;
        if (this.logicModelItem instanceof LogicModelItem.SelectItem) {
            optionItems = ((LogicModelItem.SelectItem)((Object)this.logicModelItem)).getOptionItems(requestContext.getDataModel(), dmk);
        }
        if ((miDTO = requestContext.getDataModel().getModelItem(dmk)) == null || miDTO.getValue() == null) {
            return null;
        }
        return Collections.singletonList(new ExpertDisplayInfoDTO.ListDTO.ValueRowDTO(miDTO, this.converter, optionItems));
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            AbstractConverter converter = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof AbstractConverter) {
                        converter = (AbstractConverter)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            ExpertDisplayUtil.TypeAndConverter typeAndConverter = ExpertDisplayUtil.parseInputType(element, converter);
            ExpertListValueRowItem eli = new ExpertListValueRowItem(element.getAttributeValue("value"), typeAndConverter.converter);
            return new ClassObjectPair(ExpertListValueRowItem.class, (Object)eli);
        }
    }
}

