/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.engine.expertdisplay.ExtraPagesSumItem;
import ch.dvbern.tax.common.presentation.common.util.Render;
import ch.dvbern.tax.common.presentation.common.util.RenderBuilder;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertTableColumn
extends ExpertDisplayModelItem {
    private final String title;
    private final int type;
    private final int width;
    private final int alignment;
    private final String readonlyItemName;
    private LogicModelItem readonlyItem;
    private final FontDTO font;
    private final ColorDTO bgColor;
    private final String logicModelItemName;
    private LogicModelItem logicModelItem;
    private final AbstractConverter rendererAndInputValidator;
    private final Map<String, ExpertDisplayInfoDTO.ValuePositionDTO> valuePositions;
    private final List<ExpertLabelAddOn> labelAddOns;
    private final String key;
    private final boolean isExtraPagesSum;
    private final String extraPagesSumKey;
    private final ExtraPagesSumItem extraPagesSumPos;
    private final boolean submitOnChange;
    private final String buttonValueItemName;
    private LogicModelItem buttonValueItem;
    private final String uri;
    private final String icon;
    private boolean blankItem = false;
    private final boolean autoWidthOnFocus;
    private final Render reRender;
    private Boolean readonly;

    public ExpertTableColumn(String title, int type, int width, int alignment, Boolean readonly, FontDTO font, ColorDTO bgColor, String logicModelItemName, AbstractConverter rendererAndInputValidator, Map<String, ExpertDisplayInfoDTO.ValuePositionDTO> valuePositions, String key, List<ExpertLabelAddOn> labelAddOns, boolean isExtraPagesSum, String extraPagesSumKey, int printMode, boolean inputColumn, ExtraPagesSumItem extraPagesSumPos, boolean submitOnChange, String buttonValueItemName, String icon, String uri, boolean blankItem, boolean autoWidthOnFocus, String readonlyItemName, Render reRender) {
        super(null, printMode, inputColumn);
        this.title = title;
        this.type = type;
        this.width = width;
        this.alignment = alignment;
        this.readonly = readonly;
        this.font = font;
        this.bgColor = bgColor;
        this.logicModelItemName = logicModelItemName;
        this.rendererAndInputValidator = rendererAndInputValidator;
        this.valuePositions = valuePositions;
        this.labelAddOns = labelAddOns;
        this.key = key;
        this.isExtraPagesSum = isExtraPagesSum;
        this.extraPagesSumKey = extraPagesSumKey;
        this.extraPagesSumPos = extraPagesSumPos;
        this.submitOnChange = submitOnChange;
        this.buttonValueItemName = buttonValueItemName;
        this.icon = icon;
        this.uri = uri;
        this.blankItem = blankItem;
        this.autoWidthOnFocus = autoWidthOnFocus;
        this.readonlyItemName = readonlyItemName;
        this.reRender = reRender;
    }

    public LogicModelItem getLogicModelItem() {
        return this.logicModelItem;
    }

    public List<ExpertLabelAddOn> getChildren() {
        return this.labelAddOns;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.logicModelItemName != null) {
            this.logicModelItem = logicModelItems.get(this.logicModelItemName);
            if (this.logicModelItem == null) {
                throw new InvalidModelException("invalid item reference (" + this.logicModelItemName + ") in " + this.getClass().getName());
            }
            if (this.readonly == null && this.readonlyItemName == null) {
                this.readonly = this.logicModelItem.isReadonly();
            }
        }
        if (this.buttonValueItemName != null) {
            this.buttonValueItem = logicModelItems.get(this.buttonValueItemName);
            if (this.buttonValueItem == null) {
                throw new InvalidModelException("invalid item reference (" + this.buttonValueItemName + ") in " + this.getClass().getName());
            }
        }
        if (this.readonlyItemName != null) {
            this.readonlyItem = logicModelItems.get(this.readonlyItemName);
            if (this.readonlyItem == null) {
                throw new InvalidModelException("invalid item reference (" + this.readonlyItemName + ") in " + this.getClass().getName());
            }
        }
    }

    private FontDTO getCellFont(FontDTO tableCellFont, ExpertDisplayModel.RequestContext requestContext) {
        if (this.font != null) {
            return this.font;
        }
        if (tableCellFont != null) {
            return tableCellFont;
        }
        if (requestContext.getDefaultTableFont() != null) {
            return requestContext.getDefaultTableFont();
        }
        return requestContext.getDefaultFont();
    }

    private FontDTO getHeaderFont(FontDTO tableHeaderFont, ExpertDisplayModel.RequestContext requestContext) {
        if (tableHeaderFont != null) {
            return tableHeaderFont;
        }
        if (requestContext.getDefaultTableHeaderFont() != null) {
            return requestContext.getDefaultTableHeaderFont();
        }
        if (this.font != null) {
            return this.font;
        }
        if (requestContext.getDefaultTableFont() != null) {
            return requestContext.getDefaultTableFont();
        }
        return requestContext.getDefaultFont();
    }

    public ExpertDisplayInfoDTO.TableDTO.ColumnDTO getColumnDTO(ExpertDisplayModel.RequestContext requestContext, FontDTO tableHeaderFont, FontDTO tableCellFont) {
        FontDTO headerFontDTO = this.getHeaderFont(tableHeaderFont, requestContext);
        FontDTO cellFontDTO = this.getCellFont(tableCellFont, requestContext);
        ExpertDisplayInfoDTO.TableDTO.ExtraPagesSumDTO extraPagesSumDTO = null;
        if (this.extraPagesSumPos != null) {
            extraPagesSumDTO = this.extraPagesSumPos.getDTO(headerFontDTO, this.alignment);
        }
        Boolean ro = this.readonly != null ? this.readonly : false;
        if (this.readonlyItem != null) {
            String dmk = ExpertDisplayUtil.getModelItemKey(this.readonlyItem, requestContext.getFormAccessKey());
            ModelItemDTO miDTO = requestContext.getDataModel().getModelItem(dmk);
            if (miDTO != null && Boolean.TRUE.equals(miDTO.getValue())) {
                ro = true;
            }
        }
        return new ExpertDisplayInfoDTO.TableDTO.ColumnDTO(this.title, this.type, this.width, this.alignment, ro, headerFontDTO, this.bgColor, this.rendererAndInputValidator, this.valuePositions, this.isExtraPagesSum, this.extraPagesSumKey, this.getPrintMode(), this.isInputItem(), extraPagesSumDTO, this.submitOnChange, this.autoWidthOnFocus, this.getUniqueItemIdentifier(), this.logicModelItemName, cellFontDTO);
    }

    public ExpertDisplayInfoDTO.TableDTO.CellDTO getCellDTO(ExpertDisplayModel.RequestContext requestContext, String rowFormAccessKey, FontDTO tableCellFont) {
        if (this.uri != null) {
            String cmdDmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, rowFormAccessKey);
            String valueDmk = ExpertDisplayUtil.getModelItemKey(this.buttonValueItem, rowFormAccessKey);
            return new ExpertDisplayInfoDTO.TableDTO.ButtonCellDTO(cmdDmk, valueDmk, this.key, this.icon, this.uri, requestContext.getDataModel().get(cmdDmk), 1, this.getUniqueItemIdentifier().appendLocal(rowFormAccessKey), this.getCellFont(tableCellFont, requestContext), this.reRender);
        }
        if (this.key == null) {
            String cellDMK = ExpertDisplayUtil.getModelItemKey(this.getLogicModelItem(), rowFormAccessKey);
            ModelItemDTO cellMiDTO = requestContext.getDataModel().getModelItem(cellDMK);
            OptionItemsDTO optionItems = null;
            LogicModelItem lmi = this.getLogicModelItem();
            if (lmi instanceof LogicModelItem.SelectItem) {
                optionItems = ((LogicModelItem.SelectItem)((Object)lmi)).getOptionItems(requestContext.getDataModel(), cellDMK);
            }
            if (this.type == 2) {
                ExpertDisplayUtil.handleBlankItem(optionItems, this.blankItem);
            }
            return new ExpertDisplayInfoDTO.TableDTO.ValueCellDTO(cellDMK, cellMiDTO, optionItems, 1, this.getUniqueItemIdentifier().appendLocal(cellDMK), this.getCellFont(tableCellFont, requestContext), this.reRender);
        }
        ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> labelAddOnDTOs = null;
        if (this.labelAddOns != null && !this.labelAddOns.isEmpty()) {
            labelAddOnDTOs = new ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO>();
            Iterator<ExpertLabelAddOn> iterator = this.labelAddOns.iterator();
            while (iterator.hasNext()) {
                ExpertLabelAddOn object;
                ExpertLabelAddOn labelAddOn = object = iterator.next();
                ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO labelAddOnDTO = labelAddOn.getLabelAddOnDTO(requestContext, rowFormAccessKey);
                labelAddOnDTOs.add(labelAddOnDTO);
            }
        }
        return new ExpertDisplayInfoDTO.TableDTO.LabelCellDTO(this.key, labelAddOnDTOs, 1, this.getUniqueItemIdentifier().appendLocal(rowFormAccessKey), this.getCellFont(tableCellFont, requestContext));
    }

    public String getExtraPagesSumKey() {
        return this.extraPagesSumKey;
    }

    public boolean isExtraPagesSum() {
        return this.isExtraPagesSum;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String key;
            List elements = element.getChildren();
            HashMap<String, ExpertDisplayInfoDTO.ValuePositionDTO> valuePositions = null;
            FontDTO font = null;
            AbstractConverter converter = null;
            ArrayList<ExpertLabelAddOn> labelAddOns = null;
            ExtraPagesSumItem extraPagesSumPos = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertDisplayInfoDTO.ValuePositionDTO) {
                        ExpertDisplayInfoDTO.ValuePositionDTO vp = (ExpertDisplayInfoDTO.ValuePositionDTO)ref;
                        if (valuePositions == null) {
                            valuePositions = new HashMap<String, ExpertDisplayInfoDTO.ValuePositionDTO>();
                        }
                        valuePositions.put(vp.getValue(), vp);
                        continue;
                    }
                    if (ref instanceof ExpertLabelAddOn) {
                        if (labelAddOns == null) {
                            labelAddOns = new ArrayList<ExpertLabelAddOn>();
                        }
                        labelAddOns.add((ExpertLabelAddOn)ref);
                        continue;
                    }
                    if (ref instanceof FontDTO) {
                        font = (FontDTO)ref;
                        continue;
                    }
                    if (ref instanceof AbstractConverter) {
                        converter = (AbstractConverter)ref;
                        continue;
                    }
                    if (ref instanceof ExtraPagesSumItem) {
                        extraPagesSumPos = (ExtraPagesSumItem)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            ExpertDisplayUtil.TypeAndConverter typeAndConverter = ExpertDisplayUtil.parseInputType(element, converter);
            String value = element.getAttributeValue("value");
            if (value == null) {
                value = element.getAttributeValue("buttonCommand");
            }
            if ((key = element.getAttributeValue("key")) == null && value == null) {
                throw new ElementParserException("a column must have a key or a value");
            }
            if (key == null && labelAddOns != null && !labelAddOns.isEmpty()) {
                throw new ElementParserException("you must specify a key if you add label-add-ons");
            }
            boolean isExtraPagesSum = ExpertDisplayUtil.getBoolean(element.getAttributeValue("extraPagesSum"), false);
            String extraPagesSumKey = element.getAttributeValue("extraPagesSumKey");
            if (isExtraPagesSum && extraPagesSumKey != null) {
                throw new ElementParserException("a column can't have a extraPagesSumKey and be a extra pages sum");
            }
            String readonlyStr = element.getAttributeValue("readonly");
            Boolean readOnly = readonlyStr != null ? Boolean.valueOf(readonlyStr) : null;
            Render reRender = new Render();
            if (element.getAttribute("reRender") != null) {
                reRender = RenderBuilder.create(element.getAttributeValue("reRender")).build();
            }
            ExpertTableColumn etc = new ExpertTableColumn(element.getAttributeValue("title"), typeAndConverter.type, ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.parseHAlignment(element.getAttributeValue("halign")), readOnly, font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), value, typeAndConverter.converter, valuePositions, key, labelAddOns, isExtraPagesSum, extraPagesSumKey, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printColumn"), 8), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputColumn"), true), extraPagesSumPos, ExpertDisplayUtil.getBoolean(element.getAttributeValue("submitOnChange"), false), element.getAttributeValue("buttonValue"), element.getAttributeValue("icon"), element.getAttributeValue("URI"), ExpertDisplayUtil.getBoolean(element.getAttributeValue("blank-item"), true), ExpertDisplayUtil.getBoolean(element.getAttributeValue("auto-width-on-focus"), false), element.getAttributeValue("readonly-ref"), reRender);
            return new ClassObjectPair(ExpertDisplayModelItem.class, (Object)etc);
        }
    }
}

