/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.comparators.ExpertTableComparatorProvider;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertReadonlyHelper;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableColumn;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertTableItem
extends ExpertFormDisplayModelItem {
    static final ColorDTO BLACK = new ColorDTO(0, 0, 0);
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    protected final int headerHeight;
    protected final int formRows;
    protected final int extraPagesFormRows;
    protected final float rowHeight;
    protected final float colSpace;
    protected final float extraPagesRowPadding;
    protected final FontDTO cellFont;
    protected final FontDTO titleFont;
    protected final FontDTO headerFont;
    protected final ExpertDisplayInfoDTO.PatternDTO titlePattern;
    protected final ColorDTO bgColor;
    protected final String logicModelItemName;
    protected LogicModelItem logicModelItem;
    protected Boolean readonly;
    protected Boolean readonlyIfTransparent;
    protected final List<ExpertTableColumn> columns;
    protected final List<ExpertFormDisplayModelItem> enhancedFormElements;
    protected final boolean enhanced;
    protected boolean singleton;
    protected final String title;
    protected final String printRowStateItemName;
    protected LogicModelItem printRowStateItem;
    protected final ColorDTO borderColor;
    protected final ExpertReadonlyHelper expertReadonlyHelper = new ExpertReadonlyHelper();
    protected final boolean headerVisible;
    protected final int startRow;
    protected final int endRow;
    protected final ExpertTableComparatorProvider comparatorProvider;
    protected final int onlyMultiplesOf;
    protected final float extraPagesPrintOffsetX;
    protected final float extraPagesPrintOffsetY;
    private static Comparator<Object> tableRowSorter = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return Integer.valueOf((String)o1).compareTo(Integer.valueOf((String)o2));
            }
            return 0;
        }
    };

    public ExpertTableItem(int x, int y, int width, int height, int headerHeight, int formRows, int extraPagesFormRows, FontDTO font, FontDTO titleFont, FontDTO headerFont, ExpertDisplayInfoDTO.PatternDTO titlePattern, ColorDTO bgColor, String logicModelItemName, Boolean readonly, List<ExpertTableColumn> columns, List<ExpertFormDisplayModelItem> enhancedFormElements, int printMode, boolean inputItem, float rowHeight, String title, float colSpace, Set<String> languages, String printRowsItemName, ColorDTO borderColor, float extraPagesRowPadding, Boolean readonlyIfTransparent, boolean headerVisible, int startRow, int endRow, ExpertTableComparatorProvider comparatorProvider, int onlyMultiplesOf, float extraPagesPrintOffsetX, float extraPagesPrintOffsetY) {
        super(languages, printMode, inputItem);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.headerHeight = headerHeight;
        this.formRows = formRows;
        this.extraPagesFormRows = extraPagesFormRows;
        this.cellFont = font;
        this.titleFont = titleFont;
        this.headerFont = headerFont;
        this.titlePattern = titlePattern;
        this.bgColor = bgColor;
        this.logicModelItemName = logicModelItemName;
        this.readonly = readonly;
        this.columns = columns;
        this.enhancedFormElements = enhancedFormElements;
        this.rowHeight = rowHeight;
        this.enhanced = enhancedFormElements != null;
        this.title = title;
        this.colSpace = colSpace;
        this.printRowStateItemName = printRowsItemName;
        this.borderColor = borderColor;
        this.extraPagesRowPadding = extraPagesRowPadding;
        this.readonlyIfTransparent = readonlyIfTransparent;
        this.headerVisible = headerVisible;
        this.startRow = startRow;
        this.endRow = endRow;
        this.comparatorProvider = comparatorProvider;
        this.onlyMultiplesOf = onlyMultiplesOf;
        this.extraPagesPrintOffsetX = extraPagesPrintOffsetX;
        this.extraPagesPrintOffsetY = extraPagesPrintOffsetY;
    }

    protected ExpertDisplayInfoDTO.TableDTO tableDTOConstructor(int x, int y, int width, int height, int headerHeight, int formRows, int extraPagesFormRows, FontDTO titleFont, ExpertDisplayInfoDTO.PatternDTO titlePattern, ColorDTO bgColor, List<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> columns, List<ExpertDisplayInfoDTO.TableDTO.RowDTO> rows, int state, boolean readonly, boolean enhanced, int printMode, float rowHeight, float colSpace, String title, ColorDTO borderColor, float extraPagesRowPadding, String dataModelKey, DisplayItemUniqueID uniqueItemIdentifier, boolean headerVisible, boolean editable, int startRow, int endRow, int onlyMultiplesOf, float extraPagesPrintOffsetX, float extraPagesPrintOffsetY) {
        return new ExpertDisplayInfoDTO.TableDTO(x, y, width, height, headerHeight, formRows, extraPagesFormRows, titleFont, titlePattern, bgColor, columns, rows, state, readonly, enhanced, printMode, rowHeight, colSpace, title, borderColor, extraPagesRowPadding, dataModelKey, uniqueItemIdentifier, headerVisible, editable, startRow, endRow, onlyMultiplesOf, extraPagesPrintOffsetX, extraPagesPrintOffsetY);
    }

    @Override
    public List<? extends ExpertDisplayModelItem> getChildren() {
        if (this.enhancedFormElements != null) {
            return this.enhancedFormElements;
        }
        return this.columns;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.width <= 0) {
            throw new InvalidModelException("width must be greater than 0. in" + this.getClass().getName());
        }
        if (this.logicModelItemName == null) {
            this.singleton = true;
        } else {
            this.logicModelItem = logicModelItems.get(this.logicModelItemName);
            if (!(this.logicModelItem instanceof LogicModelItem.TableItem)) {
                throw new InvalidModelException("invalid value reference (" + this.logicModelItemName + ") in " + this.getClass().getName());
            }
        }
        if (this.readonly == null) {
            Boolean bl = this.readonly = this.logicModelItem != null ? Boolean.valueOf(this.logicModelItem.isReadonly()) : Boolean.FALSE;
        }
        if (this.readonlyIfTransparent == null) {
            Boolean bl = this.readonlyIfTransparent = this.logicModelItem != null ? Boolean.valueOf(this.logicModelItem.isReadonlyIfTransparent()) : Boolean.FALSE;
        }
        if (this.printRowStateItemName != null) {
            this.printRowStateItem = logicModelItems.get(this.printRowStateItemName);
            if (this.printRowStateItem == null) {
                throw new InvalidModelException("invalid printRowsItem reference (" + this.printRowStateItemName + ") in " + this.getClass().getName());
            }
        }
        if (!this.enhanced && this.columns == null) {
            throw new InvalidModelException("missing table content (" + this.logicModelItemName + ") in " + this.getClass().getName());
        }
        this.expertReadonlyHelper.init(logicModelItems, this.logicModelItem);
    }

    protected int getColumnCount() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.size();
    }

    protected int getFormElementCount() {
        if (this.enhancedFormElements == null) {
            return 0;
        }
        return this.enhancedFormElements.size();
    }

    @Override
    public ExpertDisplayInfoDTO.TableDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        boolean ro;
        int i;
        Integer parentState;
        Set unsortedRowIndices;
        if (this.singleton) {
            return this.getSingletonTableItemDTO(requestContext);
        }
        if (this.enhanced) {
            return this.getEnhancedItemDTO(requestContext);
        }
        ArrayList<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> columnDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.ColumnDTO>();
        for (ExpertTableColumn etc : this.columns) {
            columnDTOs.add(etc.getColumnDTO(requestContext, this.headerFont, this.cellFont));
        }
        ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO> rowDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO>();
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        ModelItemDTO tableMiDTO = requestContext.getDataModel().get(dmk);
        Set set = unsortedRowIndices = tableMiDTO != null && tableMiDTO.getValue() != null ? (Set)tableMiDTO.getValue() : null;
        if (unsortedRowIndices != null && !unsortedRowIndices.isEmpty()) {
            ArrayList rowIndices = new ArrayList(unsortedRowIndices);
            Collections.sort(rowIndices, tableRowSorter);
            for (Object rowIndice : rowIndices) {
                String rowIndex = rowIndice.toString();
                ModelItemDTO rowMiDTO = requestContext.getDataModel().get(dmk + "." + rowIndex);
                if (rowMiDTO == null) continue;
                ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO> cellDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO>();
                String rowFormAccessKey = this.buildRowFormAccessKey(requestContext, rowIndex);
                for (ExpertTableColumn column : this.columns) {
                    cellDTOs.add(column.getCellDTO(requestContext, rowFormAccessKey, this.cellFont));
                }
                boolean printRow = this.isPrintRow(requestContext, rowFormAccessKey);
                String tableRowDmk = dmk + "." + rowIndex;
                rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(rowMiDTO.getState(), cellDTOs, tableRowDmk, printRow, true, this.getUniqueItemIdentifier().appendLocal(tableRowDmk), false));
            }
        }
        if (this.comparatorProvider != null) {
            Collections.sort(rowDTOs, this.comparatorProvider.newComparator(requestContext.getDataModel()));
        }
        if (tableMiDTO != null && tableMiDTO.getState() != 12 && (parentState = ExpertDisplayUtil.getDisabledOrTransparentParentState(this.logicModelItem, requestContext.getDataModel(), dmk)) != null && ((i = parentState.intValue()) == 12 || i == 11)) {
            tableMiDTO = tableMiDTO.clone(i);
        }
        if (!(ro = this.expertReadonlyHelper.evaluateReadonlyMode(this.readonly, this.readonlyIfTransparent, this.logicModelItem, tableMiDTO, dmk, requestContext.getDataModel()))) {
            int newRowIndex = EngineUtil.getNextTableItemIndex((LogicModelItem.ProtectedMap)requestContext.getDataModel(), (LogicModelItem.TableItem)((Object)this.logicModelItem), dmk);
            boolean writeOnView = requestContext.getDataModel().getWriteOnView();
            requestContext.getDataModel().setWriteOnView(false);
            ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO> cellDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO>();
            String rowFormAccessKey = this.buildRowFormAccessKey(requestContext, "" + newRowIndex);
            rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(3, cellDTOs, "", false, true, this.getUniqueItemIdentifier().appendLocal(rowFormAccessKey), true));
            Iterator<ExpertTableColumn> iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                ExpertTableColumn element;
                ExpertTableColumn etc = element = iterator.next();
                cellDTOs.add(etc.getCellDTO(requestContext, rowFormAccessKey, this.cellFont));
            }
            requestContext.getDataModel().setWriteOnView(writeOnView);
        }
        return this.tableDTOConstructor(this.x, this.y, this.width, this.height, this.headerHeight, this.formRows, this.extraPagesFormRows, this.titleFont != null ? this.titleFont : requestContext.getDefaultTableTitleFont(), this.titlePattern != null ? this.titlePattern : requestContext.getDefaultTableTitlePattern(), this.bgColor, columnDTOs, rowDTOs, tableMiDTO != null ? tableMiDTO.getState() : 3, ro, this.enhanced, this.getPrintMode(), this.rowHeight, this.colSpace, this.title, this.borderColor, this.extraPagesRowPadding, dmk, new DisplayItemUniqueID(ExpertTableItem.class.getName(), this.getUniqueItemIdentifier().getId()), this.headerVisible, true, this.startRow, this.endRow, this.onlyMultiplesOf, this.extraPagesPrintOffsetX, this.extraPagesPrintOffsetY);
    }

    private boolean isPrintRow(ExpertDisplayModel.RequestContext requestContext, String rowFormAccessKey) {
        boolean printRow = true;
        if (this.printRowStateItem != null) {
            String dmk = ExpertDisplayUtil.getModelItemKey(this.printRowStateItem, rowFormAccessKey);
            ModelItemDTO modelItem = requestContext.getDataModel().getWithoutTouch(dmk);
            if (modelItem != null) {
                printRow = modelItem.getState() != 12;
            }
        }
        return printRow;
    }

    private ExpertDisplayInfoDTO.TableDTO getEnhancedItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        boolean ro;
        int i;
        Integer parentState;
        Set unsortedRowIndices;
        ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO> rowDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO>();
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        ModelItemDTO tableMiDTO = requestContext.getDataModel().get(dmk);
        Set set = unsortedRowIndices = tableMiDTO != null && tableMiDTO.getValue() != null ? (Set)tableMiDTO.getValue() : null;
        if (unsortedRowIndices != null && !unsortedRowIndices.isEmpty()) {
            ArrayList rowIndices = new ArrayList(unsortedRowIndices);
            Collections.sort(rowIndices, tableRowSorter);
            for (Object rowIndice : rowIndices) {
                String rowIndex = rowIndice.toString();
                ModelItemDTO rowMiDTO = requestContext.getDataModel().get(dmk + "." + rowIndex);
                String rowFormAccessKey = this.buildRowFormAccessKey(requestContext, rowIndex);
                boolean printRow = this.isPrintRow(requestContext, rowFormAccessKey);
                if (rowMiDTO == null || !printRow) continue;
                ArrayList<ExpertDisplayInfoDTO.ItemDTO> rowFormElementDTOs = new ArrayList<ExpertDisplayInfoDTO.ItemDTO>();
                String rowDmk = dmk + "." + rowIndex;
                rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(rowMiDTO.getState(), rowFormElementDTOs, rowDmk, true, true, this.getUniqueItemIdentifier().appendLocal(rowDmk), false));
                for (ExpertFormDisplayModelItem fe : this.enhancedFormElements) {
                    ExpertDisplayModel.RequestContext rowReqCtx = new ExpertDisplayModel.RequestContext(requestContext.getDataModel(), rowFormAccessKey, requestContext.getDefaultFont(), requestContext.getDefaultTableFont(), requestContext.getDefaultTableHeaderFont(), requestContext.getDefaultTableTitleFont(), requestContext.getDefaultTableTitlePattern(), requestContext.getLogicModelItems());
                    if (!printRow) continue;
                    rowFormElementDTOs.add(fe.getItemDTO(rowReqCtx));
                }
            }
        }
        if (tableMiDTO != null && tableMiDTO.getState() != 12 && (parentState = ExpertDisplayUtil.getDisabledOrTransparentParentState(this.logicModelItem, requestContext.getDataModel(), dmk)) != null && ((i = parentState.intValue()) == 12 || i == 11)) {
            tableMiDTO = tableMiDTO.clone(i);
        }
        if (!(ro = this.expertReadonlyHelper.evaluateReadonlyMode(this.readonly, this.readonlyIfTransparent, this.logicModelItem, tableMiDTO, dmk, requestContext.getDataModel()))) {
            int newRowIndex = EngineUtil.getNextTableItemIndex((LogicModelItem.ProtectedMap)requestContext.getDataModel(), (LogicModelItem.TableItem)((Object)this.logicModelItem), dmk);
            boolean writeOnView = requestContext.getDataModel().getWriteOnView();
            requestContext.getDataModel().setWriteOnView(false);
            ArrayList<ExpertDisplayInfoDTO.ItemDTO> rowFormElementDTOs = new ArrayList<ExpertDisplayInfoDTO.ItemDTO>();
            String rowFormAccessKey = this.buildRowFormAccessKey(requestContext, "" + newRowIndex);
            rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(3, rowFormElementDTOs, "", false, true, this.getUniqueItemIdentifier().appendLocal(dmk + "." + newRowIndex), true));
            for (ExpertFormDisplayModelItem fe : this.enhancedFormElements) {
                ExpertDisplayModel.RequestContext rowReqCtx = new ExpertDisplayModel.RequestContext(requestContext.getDataModel(), rowFormAccessKey, requestContext.getDefaultFont(), requestContext.getDefaultTableFont(), requestContext.getDefaultTableHeaderFont(), requestContext.getDefaultTableTitleFont(), requestContext.getDefaultTableTitlePattern(), requestContext.getLogicModelItems());
                rowFormElementDTOs.add(fe.getItemDTO(rowReqCtx));
            }
            requestContext.getDataModel().setWriteOnView(writeOnView);
        }
        return this.tableDTOConstructor(this.x, this.y, this.width, this.height, this.headerHeight, this.formRows, this.extraPagesFormRows, this.titleFont != null ? this.titleFont : requestContext.getDefaultTableTitleFont(), this.titlePattern != null ? this.titlePattern : requestContext.getDefaultTableTitlePattern(), this.bgColor, null, rowDTOs, tableMiDTO != null ? tableMiDTO.getState() : 3, ro, this.enhanced, this.getPrintMode(), this.rowHeight, this.colSpace, this.title, this.borderColor, this.extraPagesRowPadding, dmk, this.getUniqueItemIdentifier(), this.headerVisible, true, this.startRow, this.endRow, this.onlyMultiplesOf, this.extraPagesPrintOffsetX, this.extraPagesPrintOffsetY);
    }

    private ExpertDisplayInfoDTO.TableDTO getSingletonTableItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        ArrayList<ExpertDisplayInfoDTO.ItemDTO> rowFormElementDTOs = new ArrayList<ExpertDisplayInfoDTO.ItemDTO>();
        ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO> rowDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO>(1);
        ArrayList<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> columnDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.ColumnDTO>();
        if (this.isPrintRow(requestContext, requestContext.getFormAccessKey())) {
            if (this.enhanced) {
                if (this.isPrintRow(requestContext, requestContext.getFormAccessKey())) {
                    for (ExpertFormDisplayModelItem fe : this.enhancedFormElements) {
                        rowFormElementDTOs.add(fe.getItemDTO(requestContext));
                    }
                    rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(1, rowFormElementDTOs, null, true, true, null, false));
                }
            } else {
                columnDTOs = new ArrayList();
                ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO> cellDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO>(this.columns.size());
                for (ExpertTableColumn column : this.columns) {
                    columnDTOs.add(column.getColumnDTO(requestContext, this.headerFont, this.cellFont));
                    cellDTOs.add(column.getCellDTO(requestContext, requestContext.getFormAccessKey(), this.cellFont));
                }
                rowDTOs.add(new ExpertDisplayInfoDTO.TableDTO.RowDTO(1, cellDTOs, null, true, true, null, false));
            }
        }
        return this.tableDTOConstructor(this.x, this.y, this.width, this.height, this.headerHeight, this.formRows, this.extraPagesFormRows, this.titleFont != null ? this.titleFont : requestContext.getDefaultTableTitleFont(), this.titlePattern != null ? this.titlePattern : requestContext.getDefaultTableTitlePattern(), this.bgColor, Collections.emptyList(), rowDTOs, 1, this.readonly, this.enhanced, this.getPrintMode(), this.rowHeight, this.colSpace, this.title, this.borderColor, this.extraPagesRowPadding, null, this.getUniqueItemIdentifier(), this.headerVisible, true, 0, Integer.MAX_VALUE, this.onlyMultiplesOf, this.extraPagesPrintOffsetX, this.extraPagesPrintOffsetY);
    }

    private String buildRowFormAccessKey(ExpertDisplayModel.RequestContext requestContext, String rowIndex) {
        Object result = requestContext.getFormAccessKey();
        result = ((String)result).indexOf(35) < 0 ? (String)result + "#" + rowIndex : (((String)result).endsWith("#") || ((String)result).endsWith(".") ? (String)result + rowIndex : (String)result + "." + rowIndex);
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            int extraPagesRows;
            int rows;
            List elements = element.getChildren();
            ArrayList<ExpertTableColumn> tableColumns = null;
            FontDTO font = null;
            FontDTO titleFont = null;
            FontDTO headerFont = null;
            ExpertDisplayInfoDTO.PatternDTO titlePattern = null;
            ArrayList<ExpertFormDisplayModelItem> enhancedFormElements = null;
            ExpertTableComparatorProvider comparatorProvider = null;
            for (Object element2 : elements) {
                Element subElement = (Element)element2;
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertTableColumn) {
                        if (tableColumns == null) {
                            tableColumns = new ArrayList<ExpertTableColumn>();
                        }
                        tableColumns.add((ExpertTableColumn)ref);
                        continue;
                    }
                    if (ref instanceof FontDTO) {
                        if ("e-table-title-font".equals(subElementName)) {
                            titleFont = (FontDTO)ref;
                            continue;
                        }
                        if ("e-table-header-font".equals(subElementName)) {
                            headerFont = (FontDTO)ref;
                            continue;
                        }
                        font = (FontDTO)ref;
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.PatternDTO) {
                        titlePattern = (ExpertDisplayInfoDTO.PatternDTO)ref;
                        continue;
                    }
                    if (ref instanceof ExpertFormDisplayModelItem) {
                        if (enhancedFormElements == null) {
                            enhancedFormElements = new ArrayList<ExpertFormDisplayModelItem>();
                        }
                        enhancedFormElements.add((ExpertFormDisplayModelItem)ref);
                        continue;
                    }
                    if (ref instanceof ExpertTableComparatorProvider) {
                        comparatorProvider = (ExpertTableComparatorProvider)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (tableColumns != null && enhancedFormElements != null) {
                throw new ElementParserException("You cannot mix e-table-col and other type of expert model item inside the same table.");
            }
            Boolean readonly = null;
            if (element.getAttribute("readonly") != null) {
                readonly = Boolean.valueOf(element.getAttributeValue("readonly"));
            }
            Boolean readonlyIfTransparent = null;
            if (element.getAttribute("readonly-if-transparent") != null) {
                readonlyIfTransparent = Boolean.valueOf(element.getAttributeValue("readonly-if-transparent"));
            }
            String rowsStr = element.getAttributeValue("rows");
            String extraPagesRowsStr = element.getAttributeValue("extraPagesRows");
            if (rowsStr == null) {
                throw new ElementParserException("Missing required attribute: rows");
            }
            try {
                rows = Integer.parseInt(rowsStr);
                extraPagesRows = extraPagesRowsStr == null ? rows : Integer.parseInt(extraPagesRowsStr);
            }
            catch (NumberFormatException e) {
                throw new ElementParserException("Rows count must be a number.", (Throwable)e);
            }
            ExpertTableItem eti = new ExpertTableItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.toPixel(element.getAttributeValue("headerHeight")), rows, extraPagesRows, font, titleFont, headerFont, titlePattern, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), element.getAttributeValue("value"), readonly, tableColumns, enhancedFormElements, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputItem"), true), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("rowHeight")), element.getAttributeValue("title"), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("colSpace")), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), element.getAttributeValue("printRowState"), ExpertDisplayUtil.parseColor(element.getAttributeValue("borderColor"), BLACK), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("extraPagesRowPadding")), readonlyIfTransparent, ExpertDisplayUtil.getBoolean(element.getAttributeValue("headerVisible"), true), ExpertDisplayUtil.getInt(element.getAttributeValue("startRow"), 0), ExpertDisplayUtil.getInt(element.getAttributeValue("endRow"), Integer.MAX_VALUE), comparatorProvider, ExpertDisplayUtil.getInt(element.getAttributeValue("onlyMultiplesOf"), 1), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("extraPagesPrintOffsetX")), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("extraPagesPrintOffsetY")));
            return new ClassObjectPair(ExpertFormDisplayModelItem.class, (Object)eti);
        }
    }
}

