/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableItem;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertTableMerge
extends ExpertFormDisplayModelItem {
    private static final ColorDTO BLACK = new ColorDTO(0, 0, 0);
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int headerHeight;
    private final int formRows;
    private final int extraPagesFormRows;
    private final float rowHeight;
    private final float colSpace;
    private final float extraPagesRowPadding;
    private final FontDTO titleFont;
    private final ExpertDisplayInfoDTO.PatternDTO titlePattern;
    private final ColorDTO bgColor;
    private final boolean readonly;
    private final String title;
    private final List<ExpertTableItem> nestedTables;
    private boolean enhanced = false;
    private final ColorDTO borderColor;
    private final boolean headerVisible;
    private final boolean skipEmptyRows;

    public ExpertTableMerge(int x, int y, int width, int height, int headerHeight, int formRows, int extraPagesFormRows, FontDTO titleFont, ExpertDisplayInfoDTO.PatternDTO titlePattern, ColorDTO bgColor, boolean readonly, List<ExpertTableItem> nestedTables, int printMode, boolean inputItem, float rowHeight, float colSpace, String title, Set<String> languages, ColorDTO borderColor, float extraPagesRowPadding, boolean headerVisible, boolean skipEmptyRows) {
        super(languages, printMode, inputItem);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.headerHeight = headerHeight;
        this.formRows = formRows;
        this.extraPagesFormRows = extraPagesFormRows;
        this.titleFont = titleFont;
        this.titlePattern = titlePattern;
        this.bgColor = bgColor;
        this.readonly = readonly;
        this.nestedTables = nestedTables;
        this.rowHeight = rowHeight;
        this.colSpace = colSpace;
        this.title = title;
        this.borderColor = borderColor;
        this.extraPagesRowPadding = extraPagesRowPadding;
        this.headerVisible = headerVisible;
        this.skipEmptyRows = skipEmptyRows;
    }

    public List<ExpertTableItem> getChildren() {
        return this.nestedTables;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.width <= 0) {
            throw new InvalidModelException("width must be greater than 0. in" + this.getClass().getName());
        }
        if (this.nestedTables == null || this.nestedTables.isEmpty()) {
            throw new InvalidModelException("missing content in " + this.getClass().getName());
        }
        ExpertTableItem prevETI = null;
        for (ExpertTableItem eti : this.nestedTables) {
            if (prevETI != null) {
                if (prevETI.getColumnCount() != eti.getColumnCount()) {
                    throw new InvalidModelException("different nested tablestructures (columns) in " + this.getClass().getName() + " table1: " + prevETI.getTitle() + " table2: " + eti.getTitle());
                }
                if (prevETI.getFormElementCount() != eti.getFormElementCount()) {
                    throw new InvalidModelException("different nested tablestructures (elements) in " + this.getClass().getName() + " table1: " + prevETI.getTitle() + " table2: " + eti.getTitle());
                }
            }
            if (eti.getColumnCount() == 0) {
                this.enhanced = true;
            }
            prevETI = eti;
        }
    }

    @Override
    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        ArrayList<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> columnDTOs = null;
        ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO> rowDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.RowDTO>();
        int state = 1;
        String dmk = null;
        for (ExpertTableItem eti : this.nestedTables) {
            ExpertDisplayInfoDTO.TableDTO tDTO = eti.getItemDTO(requestContext);
            if (!this.enhanced) {
                columnDTOs = new ArrayList<ExpertDisplayInfoDTO.TableDTO.ColumnDTO>();
                columnDTOs.addAll(tDTO.getAllColumns());
            }
            if (this.skipEmptyRows) {
                for (ExpertDisplayInfoDTO.TableDTO.RowDTO rowDTO : tDTO.getAllRows()) {
                    boolean containsNotNullElements = false;
                    for (Object value : rowDTO.getValues()) {
                        ExpertDisplayInfoDTO.TableDTO.ValueCellDTO valueDTO;
                        ModelItemDTO modelItem;
                        ExpertDisplayInfoDTO.TableDTO.CellDTO cell;
                        if (!(value instanceof ExpertDisplayInfoDTO.TableDTO.CellDTO) || !((cell = (ExpertDisplayInfoDTO.TableDTO.CellDTO)value) instanceof ExpertDisplayInfoDTO.TableDTO.ValueCellDTO) || (modelItem = (valueDTO = (ExpertDisplayInfoDTO.TableDTO.ValueCellDTO)cell).getModelItem()).getValue() == null) continue;
                        if (!containsNotNullElements) {
                            // empty if block
                        }
                        containsNotNullElements = true;
                    }
                    if (!containsNotNullElements) continue;
                    rowDTOs.add(rowDTO);
                }
            } else {
                rowDTOs.addAll(tDTO.getAllRows());
            }
            if (ModelItemDTO.isMoreImportantState(tDTO.getState(), state)) {
                state = tDTO.getState();
            }
            dmk = tDTO.getDataModelKey();
        }
        return new ExpertDisplayInfoDTO.TableDTO(this.x, this.y, this.width, this.height, this.headerHeight, this.formRows, this.extraPagesFormRows, this.titleFont != null ? this.titleFont : requestContext.getDefaultTableTitleFont(), this.titlePattern != null ? this.titlePattern : requestContext.getDefaultTableTitlePattern(), this.bgColor, columnDTOs, rowDTOs, state, this.readonly, this.enhanced, this.getPrintMode(), this.rowHeight, this.colSpace, this.title, this.borderColor, this.extraPagesRowPadding, dmk, this.getUniqueItemIdentifier(), this.headerVisible, false, 0, Integer.MAX_VALUE, 1, 0.0f, 0.0f);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            int extraPagesRows;
            int rows;
            List elements = element.getChildren();
            ArrayList<ExpertTableItem> nestedTables = null;
            FontDTO titleFont = null;
            ExpertDisplayInfoDTO.PatternDTO titlePattern = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertTableItem) {
                        if (nestedTables == null) {
                            nestedTables = new ArrayList<ExpertTableItem>();
                        }
                        nestedTables.add((ExpertTableItem)ref);
                        continue;
                    }
                    if (ref instanceof FontDTO) {
                        if (element.getName().equals("e-table-title-font")) {
                            titleFont = (FontDTO)ref;
                            continue;
                        }
                        throw new ElementParserException("font is not supported for a table merge: " + String.valueOf(ref));
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.PatternDTO) {
                        titlePattern = (ExpertDisplayInfoDTO.PatternDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String rowsStr = element.getAttributeValue("rows");
            String extraPagesRowsStr = element.getAttributeValue("extraPagesRows");
            if (rowsStr == null) {
                throw new ElementParserException("Missing required attribute: rows");
            }
            try {
                rows = Integer.parseInt(rowsStr);
                extraPagesRows = extraPagesRowsStr == null ? rows : Integer.parseInt(extraPagesRowsStr);
            }
            catch (NumberFormatException e) {
                throw new ElementParserException("Rows count must be a number.", (Throwable)e);
            }
            ExpertTableMerge etm = new ExpertTableMerge(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.toPixel(element.getAttributeValue("headerHeight")), rows, extraPagesRows, titleFont, titlePattern, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), Boolean.valueOf(element.getAttributeValue("readonly")), nestedTables, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputItem"), true), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("rowHeight")), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("colSpace")), element.getAttributeValue("title"), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), ExpertDisplayUtil.parseColor(element.getAttributeValue("borderColor"), BLACK), ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("extraPagesRowPadding")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("headerVisible"), true), ExpertDisplayUtil.getBoolean(element.getAttributeValue("skipEmptyRows"), false));
            return new ClassObjectPair(ExpertFormDisplayModelItem.class, (Object)etm);
        }
    }
}

