/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertReadonlyHelper;
import ch.dvbern.tax.common.presentation.common.util.Render;
import ch.dvbern.tax.common.presentation.common.util.RenderBuilder;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertValueItem
extends ExpertFormDisplayModelItem {
    private final ExpertReadonlyHelper expertReadonlyHelper = new ExpertReadonlyHelper();
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int type;
    private final int alignment;
    private final FontDTO font;
    private final ColorDTO bgColor;
    private final String logicModelItemName;
    private LogicModelItem logicModelItem = null;
    private final AbstractConverter<?> rendererAndInputValidator;
    private final Map<String, ExpertDisplayInfoDTO.ValuePositionDTO> valuePositions;
    private Boolean readonly;
    private Boolean readOnlyIfTransparent;
    private final boolean submitOnChange;
    private boolean blankItem = false;
    private final boolean autoWidthOnFocus;
    private final Render reRender;

    public ExpertValueItem(int x, int y, int width, int height, int type, int alignment, FontDTO font, ColorDTO bgColor, String logicModelItemName, Boolean readonly, AbstractConverter<?> rendererAndInputValidator, Map<String, ExpertDisplayInfoDTO.ValuePositionDTO> valuePositions, int printMode, boolean inputItem, Set<String> languages, boolean submitOnChange, Boolean readOnlyIfTransparent, boolean blankItem, boolean autoWidthOnFocus, Render reRender) {
        super(languages, printMode, inputItem);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.type = type;
        this.alignment = alignment;
        this.font = font;
        this.bgColor = bgColor;
        this.logicModelItemName = logicModelItemName;
        this.readonly = readonly;
        this.rendererAndInputValidator = rendererAndInputValidator;
        this.valuePositions = valuePositions;
        this.submitOnChange = submitOnChange;
        this.readOnlyIfTransparent = readOnlyIfTransparent;
        this.blankItem = blankItem;
        this.autoWidthOnFocus = autoWidthOnFocus;
        this.reRender = reRender;
    }

    public List<ExpertDisplayModelItem> getChildren() {
        return null;
    }

    public String getLogicModelItemName() {
        return this.logicModelItemName;
    }

    public AbstractConverter getRendererAndInputValidator() {
        return this.rendererAndInputValidator;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        this.logicModelItem = logicModelItems.get(this.logicModelItemName);
        if (this.logicModelItem == null) {
            throw new InvalidModelException("invalid item reference (" + this.logicModelItemName + ") in " + this.getClass().getName());
        }
        if (this.readonly == null) {
            this.readonly = this.logicModelItem.isReadonly();
        }
        if (this.readOnlyIfTransparent == null) {
            this.readOnlyIfTransparent = this.logicModelItem.isReadonlyIfTransparent();
        }
        this.expertReadonlyHelper.init(logicModelItems, this.logicModelItem);
    }

    @Override
    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        int i;
        Integer parentState;
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        OptionItemsDTO optionItems = null;
        if (this.logicModelItem instanceof LogicModelItem.SelectItem && ((optionItems = ((LogicModelItem.SelectItem)((Object)this.logicModelItem)).getOptionItems(requestContext.getDataModel(), dmk)) == null || optionItems.getOptionKeys() == null || optionItems.getOptionKeys().isEmpty())) {
            return null;
        }
        ModelItemDTO miDTO = requestContext.getDataModel().getModelItem(dmk);
        if (miDTO != null && miDTO.getState() != 12 && (parentState = ExpertDisplayUtil.getDisabledOrTransparentParentState(this.logicModelItem, requestContext.getDataModel(), dmk)) != null && ((i = parentState.intValue()) == 12 || i == 11)) {
            miDTO = miDTO.clone(i);
        }
        boolean ro = this.expertReadonlyHelper.evaluateReadonlyMode(this.readonly, this.readOnlyIfTransparent, this.logicModelItem, miDTO, dmk, requestContext.getDataModel());
        if (this.type == 2) {
            ExpertDisplayUtil.handleBlankItem(optionItems, this.blankItem);
        }
        ExpertDisplayInfoDTO.ValueItemDTO valueItemDto = new ExpertDisplayInfoDTO.ValueItemDTO(this.x, this.y, this.width, this.height, this.font != null ? this.font : requestContext.getDefaultFont(), this.bgColor, this.alignment, this.type, dmk, miDTO, optionItems, ro, this.rendererAndInputValidator, this.valuePositions, this.getPrintMode(), this.submitOnChange, this.autoWidthOnFocus, this.getUniqueItemIdentifier(), this.logicModelItemName, this.reRender);
        if (this.getOriginalPosition() != null && this.getOriginalSize() != null) {
            valueItemDto.setOriginalSettings(this.getOriginalPosition(), this.getOriginalSize());
        }
        return valueItemDto;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("logicModelItemName", (Object)this.logicModelItemName).append("logicModelItem", (Object)this.logicModelItem).append("readonly", (Object)this.readonly).append("readOnlyIfTransparent", (Object)this.readOnlyIfTransparent).append("reRender", (Object)this.reRender).append("type", this.type).build();
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            TreeMap<String, ExpertDisplayInfoDTO.ValuePositionDTO> valuePositions = null;
            FontDTO font = null;
            AbstractConverter converter = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertDisplayInfoDTO.ValuePositionDTO) {
                        ExpertDisplayInfoDTO.ValuePositionDTO vp = (ExpertDisplayInfoDTO.ValuePositionDTO)ref;
                        if (valuePositions == null) {
                            valuePositions = new TreeMap<String, ExpertDisplayInfoDTO.ValuePositionDTO>();
                        }
                        valuePositions.put(vp.getValue(), vp);
                        continue;
                    }
                    if (ref instanceof FontDTO) {
                        font = (FontDTO)ref;
                        continue;
                    }
                    if (ref instanceof AbstractConverter) {
                        converter = (AbstractConverter)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            ExpertDisplayUtil.TypeAndConverter typeAndConverter = ExpertDisplayUtil.parseInputType(element, converter);
            Boolean readonly = null;
            if (element.getAttribute("readonly") != null) {
                readonly = Boolean.valueOf(element.getAttributeValue("readonly"));
            }
            Boolean readonlyIfTransparent = null;
            if (element.getAttribute("readonly-if-transparent") != null) {
                readonlyIfTransparent = Boolean.valueOf(element.getAttributeValue("readonly-if-transparent"));
            }
            boolean expand = false;
            int halign = ExpertDisplayUtil.parseHAlignment(element.getAttributeValue("halign"));
            expand = 2 == halign ? ExpertDisplayUtil.getBoolean(element.getAttributeValue("auto-width-on-focus"), true) : ExpertDisplayUtil.getBoolean(element.getAttributeValue("auto-width-on-focus"), false);
            Render reRender = new Render();
            if (element.getAttribute("reRender") != null) {
                reRender = RenderBuilder.create(element.getAttributeValue("reRender")).build();
            }
            ExpertValueItem evi = new ExpertValueItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), typeAndConverter.type, ExpertDisplayUtil.parseHAlignment(element.getAttributeValue("halign")), font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), element.getAttributeValue("value"), readonly, typeAndConverter.converter, valuePositions, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputItem"), true), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("submitOnChange"), false), readonlyIfTransparent, ExpertDisplayUtil.getBoolean(element.getAttributeValue("blank-item"), true), expand, reRender);
            evi.setOriginalSettings(element.getAttributeValue("x"), element.getAttributeValue("y"), element.getAttributeValue("width"), element.getAttributeValue("height"));
            return new ClassObjectPair(ExpertFormDisplayModelItem.class, (Object)evi);
        }
    }
}

