/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertWizardLinkItem
extends ExpertFormDisplayModelItem {
    private final String key;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int alignment;
    private final FontDTO font;
    private final ColorDTO bgColor;
    private final List<ExpertLabelAddOn> labelAddOns;
    private final String wizardDmk;
    private LogicModelItem logicModelItem;
    private final String stateDmks;
    private List<LogicModelItem> stateModelItems;

    public ExpertWizardLinkItem(String key, int x, int y, int width, int height, int alignment, FontDTO font, ColorDTO bgColor, List<ExpertLabelAddOn> labelAddOns, Set<String> languages, String wizardDmk, String stateDmk) {
        super(languages, 0, true);
        this.key = key;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.alignment = alignment;
        this.font = font;
        this.bgColor = bgColor;
        this.labelAddOns = labelAddOns;
        this.wizardDmk = wizardDmk;
        this.stateDmks = stateDmk;
    }

    public List<ExpertLabelAddOn> getChildren() {
        return this.labelAddOns;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        this.logicModelItem = logicModelItems.get(this.wizardDmk);
        if (this.logicModelItem == null) {
            throw new InvalidModelException("invalid wizard DMK in wizard link: " + this.wizardDmk + " in " + this.getClass().getName());
        }
        if (this.stateDmks == null) {
            this.stateModelItems = Collections.singletonList(this.logicModelItem);
        } else {
            this.stateModelItems = new ArrayList<LogicModelItem>();
            StringTokenizer st = new StringTokenizer(this.stateDmks, ",");
            while (st.hasMoreTokens()) {
                String dmk = st.nextToken();
                LogicModelItem lmi = logicModelItems.get(dmk);
                if (lmi == null) {
                    throw new InvalidModelException("invalid state DMK in wizard link: " + dmk + " in " + this.getClass().getName());
                }
                this.stateModelItems.add(lmi);
            }
        }
    }

    @Override
    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        String stateDmk;
        ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> labelAddOnDTOs = null;
        if (this.labelAddOns != null && !this.labelAddOns.isEmpty()) {
            labelAddOnDTOs = new ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO>();
            for (ExpertLabelAddOn expertLabelAddOn : this.labelAddOns) {
                ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO labelAddOnDTO = expertLabelAddOn.getLabelAddOnDTO(requestContext);
                labelAddOnDTOs.add(labelAddOnDTO);
            }
        }
        int state = -1;
        for (LogicModelItem lmi : this.stateModelItems) {
            stateDmk = ExpertDisplayUtil.getModelItemKey(lmi, requestContext.getFormAccessKey());
            ModelItemDTO miDTO = requestContext.getDataModel().getWithoutTouch(stateDmk);
            if (miDTO == null) continue;
            if (state == -1) {
                state = miDTO.getState();
                continue;
            }
            if (ModelItemDTO.isPropagatableState(state)) {
                if (!miDTO.hasMoreImportantState(state) || !miDTO.hasPropagatableState()) continue;
                state = miDTO.getState();
                continue;
            }
            if (miDTO.hasPropagatableState()) {
                state = miDTO.getState();
                continue;
            }
            if (miDTO.getState() != 11) continue;
            state = miDTO.getState();
        }
        if (state == -1) {
            state = 1;
        }
        if (state == 12) {
            return null;
        }
        for (LogicModelItem stateItem : this.stateModelItems) {
            stateDmk = ExpertDisplayUtil.getModelItemKey(stateItem, requestContext.getFormAccessKey());
            for (LogicModelItem lmi = stateItem; lmi != null; lmi = lmi.getParent()) {
                if (!lmi.isReadonlyIfTransparent()) continue;
                String s = EngineUtil.mergeModelKey(lmi.getName(), stateDmk);
                ModelItemDTO mi = requestContext.getDataModel().get(s);
                if (mi == null || mi.getState() != 11) continue;
                return null;
            }
        }
        String string = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        return new ExpertDisplayInfoDTO.WizardLinkDTO(this.x, this.y, this.width, this.height, this.font != null ? this.font : requestContext.getDefaultFont(), this.bgColor, this.alignment, this.key, labelAddOnDTOs, string, state, this.getUniqueItemIdentifier());
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<ExpertLabelAddOn> labelAddOns = null;
            FontDTO font = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertLabelAddOn) {
                        if (labelAddOns == null) {
                            labelAddOns = new ArrayList<ExpertLabelAddOn>();
                        }
                        labelAddOns.add((ExpertLabelAddOn)ref);
                        continue;
                    }
                    if (ref instanceof FontDTO) {
                        font = (FontDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String key = element.getAttributeValue("key");
            if (key == null) {
                key = element.getAttributeValue("name");
            }
            if (key == null) {
                key = element.getAttributeValue("i18nKey");
            }
            ExpertWizardLinkItem eli = new ExpertWizardLinkItem(key, ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.parseHAlignment(element.getAttributeValue("halign")), font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), labelAddOns, ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), element.getAttributeValue("wizardDmk"), element.getAttributeValue("state"));
            return new ClassObjectPair(ExpertFormDisplayModelItem.class, (Object)eli);
        }
    }
}

