/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FontXMLFactory
implements ElementParser {
    private static final ColorDTO BLACK = new ColorDTO(0, 0, 0);

    public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
        float size;
        int style = 0;
        String styleStr = element.getAttributeValue("style");
        if (styleStr != null && !styleStr.isEmpty()) {
            if ((styleStr = styleStr.toLowerCase()).contains("bold")) {
                style |= 1;
            }
            if (styleStr.contains("italic")) {
                style |= 2;
            }
            if (styleStr.contains("underlined")) {
                style |= 4;
            }
        }
        ColorDTO color = BLACK;
        String colorStr = element.getAttributeValue("color");
        if (colorStr != null && !colorStr.isEmpty()) {
            color = ExpertDisplayUtil.parseColor(colorStr);
        }
        float leading = size = ExpertDisplayUtil.getFloat(element.getAttributeValue("size"), 10.0f);
        if (element.getAttribute("line-height") != null) {
            leading = ExpertDisplayUtil.toPixelFloat(element.getAttributeValue("line-height"));
        }
        return new ClassObjectPair(FontDTO.class, (Object)new FontDTO(element.getAttributeValue("name"), size, style, color, ExpertDisplayUtil.getFloat(element.getAttributeValue("charSpace"), 0.0f), leading));
    }
}

