/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.validators.Delete;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CalcInteger
extends LogicModelItem {
    private final List<CalcItem> calcItems;

    public CalcInteger(String name, String persistenceKeyTemplate, List<CalcItem> calcItems, String doImport) {
        super(name, null, persistenceKeyTemplate, true, doImport, false, false, new SimpleValuePersistenceHint());
        this.calcItems = calcItems;
    }

    @Override
    public void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, this, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, this);
        }
    }

    @Override
    public void setValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        Object value;
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (changedEventsOnlyOutsideOfThisTable != null && dmk.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        FastStack stack = new FastStack();
        for (CalcItem ci : this.calcItems) {
            try {
                ci.evaluate(dataModel, stack, dataModelKey);
            }
            catch (RuntimeException rte) {
                throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
            }
        }
        Object object = value = !stack.isEmpty() ? stack.pop() : null;
        if (value instanceof Double || value instanceof Float) {
            value = Math.round(((Number)value).doubleValue());
        }
        super.setValue(dataModel, dmk, new ModelItemDTO(value), changedEventsOnlyOutsideOfThisTable);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<CalcItem> calcItems = new ArrayList<CalcItem>();
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add((CalcItem)ref);
                        continue;
                    }
                    if (ref instanceof Validator) {
                        if (ref instanceof Delete) {
                            throw new ElementParserException("delete validators are not allowed inside of a CalcItem!!!!" + element.getAttributeValue("name"));
                        }
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            Engine.setMax(element, validators);
            Engine.setMin(element, validators);
            Engine.setMandatory(element, validators);
            Engine.setNotNegative(element, validators);
            CalcInteger result = new CalcInteger(element.getAttributeValue("name"), element.getAttributeValue("pKey"), calcItems, element.getAttributeValue("import"));
            for (Validator v : validators) {
                result.addValidator(v);
            }
            return new ClassObjectPair(CalcInteger.class, (Object)result);
        }
    }
}

