/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.modelitems.optionitems.TableOptionItem;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Select
extends LogicModelItem
implements LogicModelItem.SelectItem,
LogicModelItem.PreselectionItem {
    private final List<OptionItemFactory> optionItemFactories;
    private final String defaultOptionName;
    private final boolean autoSetDefault;
    private boolean blankItem = false;
    private boolean localized = false;
    private final boolean hasInitialGreenState;
    private final boolean isPreselectionItem;
    private final boolean hideBlankLabelIfTransparent;

    public Select(String name, String persistenceKeyTemplate, List<OptionItemFactory> optionItemFactories, boolean readonly, String importPrevious, boolean autoSetDefault, boolean blankItem, boolean hideBlankLabelIfTransparent, String defaultOptionName, boolean hasInitialGreenState, boolean readonlyIfTransparent, boolean barcode, boolean isPreselectionItem) {
        super(name, null, persistenceKeyTemplate, readonly, importPrevious, readonlyIfTransparent, barcode, new SimpleValuePersistenceHint());
        this.optionItemFactories = optionItemFactories;
        this.autoSetDefault = autoSetDefault;
        this.blankItem = blankItem;
        this.defaultOptionName = defaultOptionName;
        this.hasInitialGreenState = hasInitialGreenState;
        this.isPreselectionItem = isPreselectionItem;
        this.hideBlankLabelIfTransparent = hideBlankLabelIfTransparent;
    }

    @Override
    public void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        Boolean lzd = null;
        Iterator<OptionItemFactory> iterator = this.optionItemFactories.iterator();
        while (iterator.hasNext()) {
            OptionItemFactory object;
            OptionItemFactory oif = object = iterator.next();
            oif.additionalInitializeReferences(logicModel, this);
            if (lzd == null) {
                lzd = oif.hasLocalizedOptions();
                continue;
            }
            if (!oif.hasLocalizedOptions() || lzd.booleanValue()) continue;
            throw new InvalidModelException(this.getName() + ": mixed localized and not localized options are not allowed");
        }
        if (lzd != null) {
            this.localized = lzd;
        }
    }

    @Override
    public OptionItemsDTO getOptionItems(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        try {
            OptionItemsDTO allOptionItems = null;
            for (OptionItemFactory factory : this.optionItemFactories) {
                OptionItemsDTO options = factory.getOptionItems(dataModel, dataModelKey);
                if (options == null || options.getOptionItems(null) == null) continue;
                if (allOptionItems == null) {
                    allOptionItems = options.shallowCopy();
                    continue;
                }
                if (this.localized) {
                    for (String langCode : allOptionItems.getLanguageCodes()) {
                        allOptionItems.getOptionItems(langCode).putAll(options.getOptionItems(langCode));
                    }
                    continue;
                }
                allOptionItems.getOptionItems(null).putAll(options.getOptionItems(null));
            }
            if (this.blankItem) {
                ModelItemDTO item;
                LinkedHashMap<Object, OptionItemDTO> lhm = new LinkedHashMap<Object, OptionItemDTO>();
                String emptyLabelKey = "label.empty.selection";
                String shortEmptyLabelKey = "label.empty.selection.short";
                boolean isResourceKey = true;
                if (this.hideBlankLabelIfTransparent && (item = dataModel.get(EngineUtil.mergeModelKey(this.getName(), dataModelKey))) != null && item.getState() == 11) {
                    shortEmptyLabelKey = "";
                    emptyLabelKey = "";
                    isResourceKey = false;
                }
                lhm.put(null, new OptionItemDTO(null, shortEmptyLabelKey, emptyLabelKey, isResourceKey));
                if (allOptionItems == null) {
                    allOptionItems = OptionItemsDTO.createPlain(lhm);
                } else if (allOptionItems.isLocalized()) {
                    for (String langCode : allOptionItems.getLanguageCodes()) {
                        LinkedHashMap<Object, OptionItemDTO> originalValues = allOptionItems.getOptionItems(langCode);
                        LinkedHashMap<Object, OptionItemDTO> copy = new LinkedHashMap<Object, OptionItemDTO>(originalValues);
                        originalValues.clear();
                        originalValues.putAll(lhm);
                        originalValues.putAll(copy);
                    }
                } else {
                    lhm.putAll(allOptionItems.getOptionItems(null));
                    allOptionItems = OptionItemsDTO.createPlain(lhm);
                }
            }
            return allOptionItems;
        }
        catch (RuntimeException re) {
            throw new RuntimeException("OptionItems creation failed for select with dmk=" + dataModelKey, re);
        }
    }

    @Override
    protected ModelItemDTO getDefaultValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        OptionItemDTO option;
        if (!this.autoSetDefault && this.defaultOptionName == null) {
            return null;
        }
        OptionItemsDTO oisDTO = this.getOptionItems(dataModel, dataModelKey);
        if (oisDTO != null && oisDTO.getOptionKeys() != null && oisDTO.getOptionKeys().size() == 1 && this.autoSetDefault) {
            OptionItemDTO oiDTO = oisDTO.get(oisDTO.getOptionKeys().iterator().next());
            ModelItemDTO result = new ModelItemDTO(oiDTO.getValue());
            result.setTouched();
            return result;
        }
        if (this.defaultOptionName != null && oisDTO != null && (option = this.getOptionItems(dataModel, dataModelKey).get(this.defaultOptionName)) != null) {
            return new ModelItemDTO(option.getValue());
        }
        return null;
    }

    @Override
    protected boolean hasAnInitialGreenState() {
        if (this.hasInitialGreenState) {
            return true;
        }
        return super.hasAnInitialGreenState();
    }

    @Override
    public boolean isPreselectionItem() {
        return this.isPreselectionItem;
    }

    @Override
    public boolean hasTableOption() {
        for (OptionItemFactory object : this.optionItemFactories) {
            if (!(object instanceof TableOptionItem)) continue;
            return true;
        }
        return false;
    }

    public static interface OptionItemFactory {
        public OptionItemsDTO getOptionItems(LogicModelItem.ProtectedMap var1, String var2);

        public void additionalInitializeReferences(Map<String, LogicModelItem> var1, LogicModelItem var2) throws InvalidModelException;

        public boolean hasLocalizedOptions();
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<OptionItemFactory> optionItems = new ArrayList<OptionItemFactory>();
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof OptionItemFactory) {
                        optionItems.add((OptionItemFactory)ref);
                        continue;
                    }
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            Engine.setMandatory(element, validators);
            String defaultValue = null;
            if (element.getAttribute("default") != null) {
                defaultValue = element.getAttributeValue("default");
            }
            boolean isPreselectionItem = true;
            if (element.getAttribute("preselection") != null) {
                isPreselectionItem = Boolean.parseBoolean(element.getAttributeValue("preselection"));
            }
            Select result = new Select(element.getAttributeValue("name"), element.getAttributeValue("pKey"), optionItems, Boolean.valueOf(element.getAttributeValue("readonly")), element.getAttributeValue("import"), Boolean.valueOf(element.getAttributeValue("auto-set-default")), Boolean.valueOf(element.getAttributeValue("blank-item")), Boolean.valueOf(element.getAttributeValue("hide-blank-label-if-transparent")), defaultValue, Boolean.valueOf(element.getAttributeValue("has-initial-green-state")), Boolean.valueOf(element.getAttributeValue("readonly-if-transparent")), Boolean.valueOf(element.getAttributeValue("barcode")), isPreselectionItem);
            validators.add(new OptionValid(result));
            for (Validator validator : validators) {
                result.addValidator(validator);
            }
            return new ClassObjectPair(Select.class, (Object)result);
        }
    }

    public static class OptionValid
    implements Validator {
        private final Select select;
        public static final String DEFAULT_ERROR_KEY = "error.invalid.select.option";

        public OptionValid(Select select) {
            this.select = select;
        }

        @Override
        public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        }

        @Override
        public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
            if (modelItemDTO.getValue() == null) {
                return modelItemDTO;
            }
            OptionItemsDTO items = this.select.getOptionItems(dataModel, dataModelKey);
            if (items != null && items.getOptionKeys().contains(modelItemDTO.getValue().toString())) {
                return modelItemDTO;
            }
            return modelItemDTO.clone(null, 4, DEFAULT_ERROR_KEY, null, 4);
        }
    }
}

