/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Table
extends LogicModelItem
implements LogicModelItem.TableItem {
    private final String sharedTableNames;
    private final Set<LogicModelItem.TableItem> sharedTables = new HashSet<LogicModelItem.TableItem>();
    private Set<LogicModelItem.TableItem.TableEventListener> tableEventListener;

    public Table(@NonNull String name, @Nullable List<LogicModelItem> children, @Nullable String persistenceKeyTemplate, boolean readonly, boolean readonlyIfTransparent, String sharedTableNames, boolean barcode) {
        super(name, children, persistenceKeyTemplate, readonly, "false", readonlyIfTransparent, barcode, new SimpleValuePersistenceHint());
        this.sharedTableNames = sharedTableNames;
    }

    @Override
    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        if (this.sharedTableNames != null) {
            StringTokenizer st = new StringTokenizer(this.sharedTableNames, ",");
            while (st.hasMoreTokens()) {
                String sharedTableName = st.nextToken().trim();
                LogicModelItem sharedTable = logicModel.get(sharedTableName);
                if (sharedTable instanceof LogicModelItem.TableItem) {
                    this.addSharedTable((LogicModelItem.TableItem)((Object)sharedTable));
                    continue;
                }
                throw new InvalidModelException("invalid sharedTable declaration (" + sharedTableName + ") in " + this.getName());
            }
        }
    }

    @Override
    public void addSharedTable(LogicModelItem.TableItem otherTable) {
        if (this != otherTable && !this.sharedTables.contains(otherTable)) {
            this.sharedTables.add(otherTable);
            otherTable.addSharedTable(this);
            for (LogicModelItem.TableItem ti : this.sharedTables) {
                ti.addSharedTable(otherTable);
                otherTable.addSharedTable(ti);
            }
        }
    }

    @Override
    public Collection<LogicModelItem.TableItem> getSharedTables() {
        return this.sharedTables;
    }

    @Override
    public void addTableEventListener(LogicModelItem.TableItem.TableEventListener listener) {
        if (this.tableEventListener == null) {
            this.tableEventListener = new HashSet<LogicModelItem.TableItem.TableEventListener>();
        }
        this.tableEventListener.add(listener);
    }

    @Override
    public Collection<LogicModelItem.TableItem.TableEventListener> getTableEventListeners() {
        return this.tableEventListener;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<LogicModelItem> childItems = !elements.isEmpty() ? new ArrayList<LogicModelItem>() : null;
            ArrayList<Object> validators = new ArrayList<Object>();
            for (Element subElement : elements) {
                try {
                    String string = subElement.getName();
                    ElementParser parser = factory.getParser(string);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LogicModelItem) {
                        childItems.add((LogicModelItem)ref);
                        continue;
                    }
                    if (ref instanceof Validator) {
                        validators.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException parserNotRegisteredException) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)parserNotRegisteredException);
                }
            }
            Table result = new Table(Objects.requireNonNull(element.getAttributeValue("name")), childItems, element.getAttributeValue("pKey"), Boolean.parseBoolean(element.getAttributeValue("readonly")), Boolean.parseBoolean(element.getAttributeValue("readonly-if-transparent")), element.getAttributeValue("sharedTables"), Boolean.parseBoolean(element.getAttributeValue("barcode")));
            for (Object e : validators) {
                result.addValidator((Validator)e);
            }
            return new ClassObjectPair(Table.class, (Object)result);
        }
    }
}

