/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableConcat
extends LogicModelItem {
    private final Reference relRef;
    private final String separator;

    public TableConcat(String name, String persistenceKeyTemplate, Reference relRef, String separator) {
        super(name, null, persistenceKeyTemplate, true, "false", false, false, new SimpleValuePersistenceHint());
        this.relRef = relRef;
        this.separator = separator == null ? "" : separator;
    }

    @Override
    public void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        this.relRef.registerListenerOnReference(logicModel, this, true);
    }

    @Override
    public void setValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        String mergedKey = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (changedEventsOnlyOutsideOfThisTable != null && mergedKey.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        ModelItemDTO oldSum = dataModel.get(mergedKey);
        StringBuilder result = new StringBuilder();
        if (oldSum != null && oldSum.getValue() != null) {
            result.append(oldSum.getValue().toString());
        }
        if (oldValue != null && oldValue.getValue() != null) {
            String old = oldValue.getValue().toString();
            int pos = result.indexOf(old);
            if (pos > -1) {
                result.delete(pos, pos + old.length());
            }
            if (!this.separator.isEmpty()) {
                if (pos == 0 && result.length() >= this.separator.length()) {
                    result.delete(0, this.separator.length());
                } else if (pos - this.separator.length() > -1) {
                    result.delete(pos - this.separator.length(), pos);
                }
            }
        }
        if (newValue != null && newValue.getValue() != null) {
            if (result.length() > 0 && !this.separator.isEmpty()) {
                result.append(this.separator);
            }
            result.append(newValue.getValue().toString());
        }
        super.setValue(dataModel, mergedKey, new ModelItemDTO(result.toString()), changedEventsOnlyOutsideOfThisTable);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String string = subElement.getName();
                    ElementParser parser = factory.getParser(string);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException parserNotRegisteredException) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)parserNotRegisteredException);
                }
            }
            TableConcat result = new TableConcat(element.getAttributeValue("name"), element.getAttributeValue("pKey"), new Reference(element.getAttributeValue("ref"), true), element.getAttributeValue("separator"));
            for (Object e : validators) {
                result.addValidator((Validator)e);
            }
            return new ClassObjectPair(TableConcat.class, (Object)result);
        }
    }
}

