/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMax
extends LogicModelItem {
    private static final Logger LOG = LoggerFactory.getLogger(TableMax.class);
    private final Reference relRef;

    public TableMax(String name, String persistenceKeyTemplate, Reference relRef) {
        super(name, null, persistenceKeyTemplate, true, "false", false, false, new SimpleValuePersistenceHint());
        this.relRef = relRef;
    }

    @Override
    public void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        this.relRef.registerListenerOnReference(logicModel, this, true);
    }

    @Override
    public void setValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        String maxItemKey = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (changedEventsOnlyOutsideOfThisTable != null && maxItemKey.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        if (newValue != null && !(newValue.getValue() instanceof Number) && !(newValue.getValue() instanceof Date)) {
            if (newValue.getValue() != null) {
                LOG.error("unsupported datatype to compare: " + String.valueOf(newValue.getValue().getClass()));
            }
            this.superSetValue(dataModel, maxItemKey, new ModelItemDTO(null), changedEventsOnlyOutsideOfThisTable);
            return;
        }
        String colName = EngineUtil.getLastKeyPart(dataModelKey);
        String tableDMK = EngineUtil.getTableDataModelKey(dataModelKey);
        assert (tableDMK != null) : "tableDMK invalid: " + dataModelKey;
        ModelItemDTO tableDTO = dataModel.get(tableDMK);
        assert (tableDTO.getValue() == null || tableDTO.getValue() instanceof Set) : "Value of a tableDTO must be null or a Set: " + dataModelKey;
        Set tableIndices = (Set)tableDTO.getValue();
        if (tableIndices == null || tableIndices.isEmpty()) {
            LOG.debug("keine tabelleneintraege vorhanden");
            this.superSetValue(dataModel, maxItemKey, new ModelItemDTO(null), changedEventsOnlyOutsideOfThisTable);
            return;
        }
        Object max = null;
        for (String index : tableIndices) {
            String tableEntryDMK = tableDMK + "." + index + "." + colName;
            ModelItemDTO dto2 = dataModel.get(tableEntryDMK);
            if (dto2 == null) continue;
            Object obj2 = dto2.getValue();
            max = this.max(max, obj2);
        }
        this.superSetValue(dataModel, maxItemKey, new ModelItemDTO(max), changedEventsOnlyOutsideOfThisTable);
    }

    private @Nullable Object max(@Nullable Object obj1, @Nullable Object obj2) {
        if (obj1 == null) {
            return obj2;
        }
        if (obj2 != null) {
            if (obj2 instanceof Long) {
                if (!(obj1 instanceof Long)) {
                    LOG.warn("comparing diffent objects: " + String.valueOf(obj1.getClass()) + " and " + String.valueOf(obj2.getClass()));
                    return null;
                }
                Long dObj1 = (Long)obj1;
                Long dObj2 = (Long)obj2;
                if (dObj1.compareTo(dObj2) > 0) {
                    return dObj1;
                }
                return dObj2;
            }
            if (obj2 instanceof Double) {
                if (!(obj1 instanceof Double)) {
                    LOG.warn("comparing diffent objects: " + String.valueOf(obj1.getClass()) + " and " + String.valueOf(obj2.getClass()));
                    return null;
                }
                Double dObj1 = (Double)obj1;
                Double dObj2 = (Double)obj2;
                if (dObj1.compareTo(dObj2) > 0) {
                    return dObj1;
                }
                return dObj2;
            }
            if (obj2 instanceof Date) {
                if (!(obj1 instanceof Date)) {
                    LOG.warn("comparing diffent objects: " + String.valueOf(obj1.getClass()) + " and " + String.valueOf(obj2.getClass()));
                    return null;
                }
                Date dObj1 = (Date)obj1;
                Date dObj2 = (Date)obj2;
                if (dObj1.after(dObj2)) {
                    return dObj1;
                }
                return dObj2;
            }
            LOG.warn("unsupported datatype to compare: " + String.valueOf(obj1.getClass()) + " and " + String.valueOf(obj2.getClass()));
            return null;
        }
        return obj1;
    }

    private void superSetValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        super.setValue(dataModel, dataModelKey, modelItemDTO, changedEventsOnlyOutsideOfThisTable);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<Object> validators = new ArrayList<Object>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String string = subElement.getName();
                    ElementParser parser = factory.getParser(string);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Validator) {
                        validators.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException parserNotRegisteredException) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)parserNotRegisteredException);
                }
            }
            TableMax result = new TableMax(element.getAttributeValue("name"), element.getAttributeValue("pKey"), new Reference(element.getAttributeValue("ref"), true));
            for (Object e : validators) {
                result.addValidator((Validator)e);
            }
            return new ClassObjectPair(TableMax.class, (Object)result);
        }
    }
}

