/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.MathUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableSum
extends LogicModelItem {
    private final @NonNull Reference relRef;

    public TableSum(@NonNull String name, @Nullable String persistenceKeyTemplate, @NonNull Reference relRef) {
        super(name, null, persistenceKeyTemplate, true, "false", false, false, new SimpleValuePersistenceHint());
        assert (relRef != null);
        this.relRef = relRef;
    }

    @Override
    public void additionalInitializeReferences(@NonNull Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        this.relRef.registerListenerOnReference(logicModel, this, true);
    }

    @Override
    public void setValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        String mergedKey = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (changedEventsOnlyOutsideOfThisTable != null && mergedKey.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        ModelItemDTO oldSumMID = dataModel.get(mergedKey);
        BigDecimal oldSumConverted = MathUtil.toBigDecimal(oldSumMID);
        BigDecimal oldValueConverted = MathUtil.toBigDecimal(oldValue);
        BigDecimal newValueConverted = MathUtil.toBigDecimal(newValue);
        BigDecimal resultBD = oldSumConverted.subtract(oldValueConverted).add(newValueConverted);
        Number resultNumber = MathUtil.toAnyNumber(resultBD);
        this.superSetValue(dataModel, mergedKey, new ModelItemDTO(resultNumber), changedEventsOnlyOutsideOfThisTable);
    }

    protected void superSetValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        super.setValue(dataModel, dataModelKey, modelItemDTO, changedEventsOnlyOutsideOfThisTable);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            TableSum result = new TableSum(element.getAttributeValue("name"), element.getAttributeValue("pKey"), new Reference(element.getAttributeValue("ref"), true));
            for (Validator element2 : validators) {
                result.addValidator(element2);
            }
            return new ClassObjectPair(TableSum.class, (Object)result);
        }
    }
}

