/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Text
extends LogicModelItem {
    private final String defaultValue;
    private final boolean hasInitialGreenState;

    public Text(@NonNull String name, @Nullable String persistenceKeyTemplate, @Nullable String defaultValue, boolean readonly, @Nullable String importPrevious, boolean hasInitialGreenState, boolean readonlyIfTransparent, boolean barcode) {
        super(name, null, persistenceKeyTemplate, readonly, importPrevious, readonlyIfTransparent, barcode, new SimpleValuePersistenceHint());
        this.defaultValue = defaultValue;
        this.hasInitialGreenState = hasInitialGreenState;
    }

    @Override
    protected ModelItemDTO getDefaultValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        return this.defaultValue != null ? new ModelItemDTO(this.defaultValue) : null;
    }

    @Override
    protected boolean hasAnInitialGreenState() {
        if (this.hasInitialGreenState) {
            return true;
        }
        return super.hasAnInitialGreenState();
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            Engine.setMandatory(element, validators);
            Text result = new Text(Objects.requireNonNull(element.getAttributeValue("name")), element.getAttributeValue("pKey"), element.getAttributeValue("default"), Boolean.parseBoolean(element.getAttributeValue("readonly")), element.getAttributeValue("import"), Boolean.parseBoolean(element.getAttributeValue("has-initial-green-state")), Boolean.parseBoolean(element.getAttributeValue("readonly-if-transparent")), Boolean.parseBoolean(element.getAttributeValue("barcode")));
            for (Validator element2 : validators) {
                result.addValidator(element2);
            }
            return new ClassObjectPair(Text.class, (Object)result);
        }
    }
}

