/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.validators.NotNegative;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Value
extends LogicModelItem {
    private final Number defaultValue;
    private final boolean hasInitialGreenState;

    public Value(String name, String persistenceKeyTemplate, @Nullable Number defaultValue, boolean readonly, String importPrevious, boolean hasInitialGreenState, boolean readonlyIfTransparent, boolean barcode) {
        super(name, null, persistenceKeyTemplate, readonly, importPrevious, readonlyIfTransparent, barcode, new SimpleValuePersistenceHint());
        this.defaultValue = defaultValue;
        this.hasInitialGreenState = hasInitialGreenState;
    }

    @Override
    protected ModelItemDTO getDefaultValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        return this.defaultValue != null ? new ModelItemDTO(this.defaultValue) : null;
    }

    @Override
    protected boolean hasAnInitialGreenState() {
        if (this.hasInitialGreenState) {
            return true;
        }
        return super.hasAnInitialGreenState();
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            Engine.setMax(element, validators);
            Engine.setMin(element, validators);
            Engine.setMandatory(element, validators);
            boolean hasExplicitFalseNotNegative = false;
            if (element.getAttribute("not-negative") != null) {
                if (Boolean.valueOf(element.getAttributeValue("not-negative")).booleanValue()) {
                    NotNegative nonNegative = new NotNegative(false, false);
                    validators.add(nonNegative);
                } else {
                    hasExplicitFalseNotNegative = true;
                }
            }
            boolean hasExplicitNotNegativeValidator = false;
            for (Validator validator : validators) {
                if (!(validator instanceof NotNegative)) continue;
                hasExplicitNotNegativeValidator = true;
            }
            if (!hasExplicitNotNegativeValidator && !hasExplicitFalseNotNegative) {
                NotNegative nonNegative = new NotNegative(false, false);
                validators.add(nonNegative);
            }
            Number defaultValue = null;
            if (element.getAttribute("default") != null) {
                String sDefaultValue = element.getAttributeValue("default");
                defaultValue = sDefaultValue.indexOf(46) >= 0 ? (Number)Double.valueOf(sDefaultValue) : (Number)Long.valueOf(sDefaultValue);
            }
            Value result = new Value(element.getAttributeValue("name"), element.getAttributeValue("pKey"), defaultValue, (boolean)Boolean.valueOf(element.getAttributeValue("readonly")), element.getAttributeValue("import"), (boolean)Boolean.valueOf(element.getAttributeValue("has-initial-green-state")), (boolean)Boolean.valueOf(element.getAttributeValue("readonly-if-transparent")), Boolean.valueOf(element.getAttributeValue("barcode")));
            for (Validator element2 : validators) {
                result.addValidator(element2);
            }
            return new ClassObjectPair(Value.class, (Object)result);
        }
    }
}

