/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.optionitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TableOptionItem
implements Select.OptionItemFactory {
    private final Reference ref;
    private final String attribute;
    private final String excludeKey;
    private LogicModelItem excludeRef;

    public TableOptionItem(Reference ref, String attribute, String excludeKey) {
        this.ref = ref;
        this.attribute = attribute;
        this.excludeKey = excludeKey;
    }

    @Override
    public OptionItemsDTO getOptionItems(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        ModelItemDTO miDTO;
        String excludeIdx = null;
        if (this.excludeRef != null) {
            ModelItemDTO excludeDTO = dataModel.get(EngineUtil.mergeModelKey(this.excludeRef.getName(), dataModelKey));
            if (excludeDTO == null || excludeDTO.getValue() == null) {
                return null;
            }
            excludeIdx = excludeDTO.getValue().toString();
        }
        TreeMap<String, OptionItemDTO> optionMap = new TreeMap<String, OptionItemDTO>();
        Object table = null;
        if (this.ref != null && (miDTO = dataModel.get(EngineUtil.mergeModelKey(this.ref.getName(), dataModelKey))) != null) {
            table = miDTO.getValue();
            String tableDmk = EngineUtil.mergeModelKey(this.ref.getName(), dataModelKey);
            Set indices = (Set)table;
            if (indices != null) {
                for (String index : indices) {
                    ModelItemDTO itemMiDTO;
                    if (excludeIdx != null && index.equals(excludeIdx) || (itemMiDTO = dataModel.get(tableDmk + "." + index + "." + this.attribute)) == null) continue;
                    OptionItemDTO optionItemDTO = new OptionItemDTO(index, index, itemMiDTO.getValue() != null ? itemMiDTO.getValue().toString() : "", false);
                    optionMap.put(index, optionItemDTO);
                }
            }
        }
        LinkedHashMap<Object, OptionItemDTO> sortedOptionMap = new LinkedHashMap<Object, OptionItemDTO>(optionMap);
        return OptionItemsDTO.createPlain(sortedOptionMap);
    }

    @Override
    public void additionalInitializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        if (this.ref != null) {
            this.ref.registerListenerOnReference(logicModel, logicModelItem, true);
        }
        if (logicModel.get(this.excludeKey) != null) {
            this.excludeRef = logicModel.get(this.excludeKey);
        }
    }

    @Override
    public boolean hasLocalizedOptions() {
        return false;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Reference tableRef = null;
            if (element.getAttribute("rel-ref") != null) {
                tableRef = new Reference(element.getAttributeValue("rel-ref"), true);
            }
            if (element.getAttribute("abs-ref") != null) {
                tableRef = new Reference(element.getAttributeValue("abs-ref"), false);
            }
            TableOptionItem result = new TableOptionItem(tableRef, element.getAttributeValue("attribute"), element.getAttributeValue("exclude-ref"));
            return new ClassObjectPair(TableOptionItem.class, (Object)result);
        }
    }
}

