/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelloader;

import ch.dvbern.tax.common.engine.modelloader.MergedModel;
import ch.dvbern.tax.common.engine.modelloader.ModelSource;
import ch.dvbern.tax.common.engine.modelloader.ModelSources;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ModelMerger {
    private static final Logger LOG = LoggerFactory.getLogger(ModelMerger.class);
    private static final Charset DEFAULT_TARGET_ENCODING = StandardCharsets.ISO_8859_1;
    private final Charset targetEncoding;

    public static @NonNull ModelMerger newInstance() {
        return new ModelMerger(DEFAULT_TARGET_ENCODING);
    }

    private ModelMerger(@NonNull Charset targetEncoding) {
        this.targetEncoding = targetEncoding;
    }

    public @NonNull MergedModel merge(@NonNull ModelSources sources, @NonNull Map<String, String> replacements) throws IOException, UnsupportedEncodingException {
        byte[] xmlBytes = new Merger(sources, replacements).merge();
        return MergedModel.from(xmlBytes, this.targetEncoding);
    }

    @NotThreadSafe
    private class Merger {
        private final @NonNull ModelSources sources;
        private final @NonNull Map<String, String> replacements;
        private final StringBuffer tmoLine = new StringBuffer();
        private final StringBuffer logicStructure = new StringBuffer();
        private final StringBuffer wizardDisplayStructure = new StringBuffer();
        private final StringBuffer expertDisplayStructure = new StringBuffer();

        private Merger(@NonNull ModelSources sources, Map<String, String> replacements) {
            this.sources = sources;
            this.replacements = replacements;
        }

        public byte[] merge() throws IOException, UnsupportedEncodingException {
            for (ModelSource source : this.sources.getSources()) {
                this.appendFrom(source);
            }
            byte[] xmlBytes = this.buildModelXml();
            return xmlBytes;
        }

        private byte[] buildModelXml() throws IOException, UnsupportedEncodingException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                PrintStream writer = new PrintStream((OutputStream)baos, true, ModelMerger.this.targetEncoding.name());
                try {
                    byte[] bytes;
                    this.writeMergedModelXml(writer);
                    writer.flush();
                    byte[] byArray = bytes = baos.toByteArray();
                    writer.close();
                    return byArray;
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }

        private void appendFrom(ModelSource source) throws IOException {
            LOG.debug("merge file: {}", (Object)source);
            try (BufferedInputStream is = new BufferedInputStream(source.getUrl().openStream());
                 BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, source.getCharset()));){
                this.appendFrom(br);
            }
        }

        private void appendFrom(BufferedReader br) throws IOException {
            ModelType modelType = ModelType.NONE;
            String line = br.readLine();
            while (line != null) {
                if (line.contains("<model-root name=") && this.tmoLine.length() == 0) {
                    this.appendLine(ModelType.MODEL_NAME, line);
                }
                if (line.contains("<logic-model") || line.contains("</wizard-display-model") || line.contains("</expert-display-model")) {
                    modelType = ModelType.LOGIC;
                }
                if (line.contains("<wizard-display-model") || line.contains("</expert-display-model") || line.contains("</logic-model")) {
                    modelType = ModelType.WIZARD_DISPLAY;
                }
                if (line.contains("<expert-display-model") || line.contains("</wizard-display-model") || line.contains("</logic-model")) {
                    modelType = ModelType.EXPERT_DISPLAY;
                }
                if (!(line.contains("<?xml") || line.contains("<!DOCTYPE") || line.contains("<model-root") || line.contains("</model-root") || line.contains("logic-model") || line.contains("wizard-display-model") || line.contains("expert-display-model"))) {
                    this.appendLine(modelType, line);
                }
                line = br.readLine();
            }
        }

        private void appendLine(ModelType modelType, String line) {
            String expandedLine = this.expandReplacements(line);
            switch (modelType.ordinal()) {
                case 1: {
                    this.tmoLine.append(expandedLine);
                    break;
                }
                case 2: {
                    this.logicStructure.append(expandedLine).append('\n');
                    break;
                }
                case 3: {
                    this.wizardDisplayStructure.append(expandedLine).append('\n');
                    break;
                }
                case 4: {
                    this.expertDisplayStructure.append(expandedLine).append('\n');
                    break;
                }
                case 0: {
                    LOG.warn("Illegal xml model syntax? Found line not belonging to any ModelType: {}", (Object)line);
                }
            }
        }

        private String expandReplacements(String line) {
            String expanded = line;
            for (Map.Entry<String, String> replacement : this.replacements.entrySet()) {
                String pattern = String.format("${%s}", replacement.getKey());
                expanded = expanded.replace(pattern, replacement.getValue());
            }
            if (expanded.contains("${")) {
                throw new IllegalStateException("Replacement missing for line: " + line);
            }
            return expanded;
        }

        private void writeMergedModelXml(PrintStream writer) {
            writer.println("<?xml version=\"1.0\" encoding=\"" + String.valueOf(ModelMerger.this.targetEncoding) + "\"?>");
            writer.println(this.tmoLine);
            writer.println("<logic-model>");
            writer.print(this.logicStructure.toString());
            writer.println("</logic-model>");
            writer.println("<wizard-display-model>");
            writer.print(this.wizardDisplayStructure.toString());
            writer.println("</wizard-display-model>");
            writer.println("<expert-display-model>");
            writer.print(this.expertDisplayStructure.toString());
            writer.println("</expert-display-model>");
            writer.println("</model-root>");
            writer.flush();
        }
    }

    private static enum ModelType {
        NONE,
        MODEL_NAME,
        LOGIC,
        WIZARD_DISPLAY,
        EXPERT_DISPLAY;

    }
}

