/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.util;

import java.math.BigDecimal;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CompareUtil {
    private CompareUtil() {
    }

    public static @Nullable Boolean compare(@NonNull Operator operator, @Nullable Object lhs, @Nullable Object rhs, boolean nullAsZero) {
        int result;
        if (operator == null) {
            throw new NullPointerException("Operator cannot be null");
        }
        if (nullAsZero) {
            if (lhs == null) {
                lhs = 0;
            }
            if (rhs == null) {
                rhs = 0;
            }
        } else if (lhs == null || rhs == null) {
            return null;
        }
        if (lhs instanceof BigDecimal && rhs instanceof BigDecimal) {
            result = ((BigDecimal)lhs).compareTo((BigDecimal)rhs);
        } else if (lhs instanceof Number && rhs instanceof Number) {
            result = Double.compare(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
        } else if (lhs instanceof String && rhs instanceof Number) {
            try {
                result = Double.compare(Double.valueOf((String)lhs), ((Number)rhs).doubleValue());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Incompatible types for values " + String.valueOf(lhs) + "/" + String.valueOf(rhs) + " = " + String.valueOf(lhs.getClass()) + "/" + String.valueOf(rhs.getClass()) + " Cannot parse Double", nfe);
            }
        } else if (lhs instanceof Comparable && rhs instanceof Comparable) {
            Comparable lhsComp = (Comparable)lhs;
            Comparable rhsComp = (Comparable)rhs;
            try {
                result = lhsComp.compareTo(rhsComp);
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Incompatible types for values " + String.valueOf(lhs) + "/" + String.valueOf(rhs) + " = " + String.valueOf(lhs.getClass()) + "/" + String.valueOf(rhs.getClass()), cce);
            }
        } else {
            throw new IllegalArgumentException("Both side of the comparison must be comparable");
        }
        switch (operator.ordinal()) {
            case 0: {
                return result > 0;
            }
            case 1: {
                return result >= 0;
            }
            case 2: {
                return result < 0;
            }
            case 3: {
                return result <= 0;
            }
            case 4: {
                return result == 0;
            }
            case 5: {
                return result != 0;
            }
        }
        throw new AssertionError((Object)"Unreachable code path.");
    }

    public static enum Operator {
        GREATER,
        GREATER_OR_EQUAL,
        SMALLER,
        SMALLER_OR_EQUAL,
        EQUAL,
        NOT_EQUAL;

    }
}

