/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.util;

import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DataModelUtil {
    public static <T> @NonNull T getRequiredValue(@NonNull Map<String, ModelItemDTO> dataModel, @NonNull Class<T> cls, @NonNull String dmk) {
        if (dataModel == null) {
            throw new NullPointerException("Data model cannot be null.");
        }
        if (cls == null) {
            throw new NullPointerException("Target class cannot be null.");
        }
        if (dmk == null) {
            throw new NullPointerException("Data model key cannot be null.");
        }
        T value = DataModelUtil.getValue(dataModel, cls, dmk);
        if (value == null) {
            throw new IllegalArgumentException("Missing required model item: " + dmk);
        }
        return value;
    }

    public static <T> @Nullable T getValue(@NonNull Map<String, ModelItemDTO> dataModel, @NonNull Class<T> cls, @NonNull String dmk) {
        Object value;
        if (dataModel == null) {
            throw new NullPointerException("Data model cannot be null.");
        }
        if (cls == null) {
            throw new NullPointerException("Target class cannot be null.");
        }
        if (dmk == null) {
            throw new NullPointerException("Data model key cannot be null.");
        }
        ModelItemDTO item = dataModel.get(dmk);
        Object object = value = item != null ? item.getValue() : null;
        if (value == null) {
            return null;
        }
        if (!cls.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(String.format("Incompatible type for required item value: %s, expected: %s, got: %s ([%s])", dmk, cls, value.getClass(), value));
        }
        return cls.cast(value);
    }
}

