/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.util;

import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertValueItem;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.util.ExpertModelVisitor;
import ch.dvbern.tax.common.engine.util.LogicModelVisitor;
import ch.dvbern.tax.common.engine.util.WizardModelVisitor;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.SelectConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticModelVisitor
implements LogicModelVisitor,
WizardModelVisitor,
ExpertModelVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(DiagnosticModelVisitor.class);
    private final List<String> debugs = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();
    private final List<String> errors = new ArrayList<String>();
    private final Map<String, ModelTuple> summaryMap = new LinkedHashMap<String, ModelTuple>();
    private final Set<String> pKeyTemplatesSet = new HashSet<String>();
    private final boolean pKeyMandatoryForEditableItems;
    private final boolean duplicatePKeyForbidden;
    private boolean running;

    public DiagnosticModelVisitor() {
        this(false, false);
    }

    public DiagnosticModelVisitor(boolean pKeyMandatoryForEditableItems, boolean duplicatePKeyForbidden) {
        this.pKeyMandatoryForEditableItems = pKeyMandatoryForEditableItems;
        this.duplicatePKeyForbidden = duplicatePKeyForbidden;
    }

    private void start() {
        this.debugs.clear();
        this.errors.clear();
        this.summaryMap.clear();
        this.running = true;
    }

    @Override
    public void accept(LogicModelItem item) {
        this.checkRunning();
        this.getOrCreateTuple((String)item.getName()).item = item;
    }

    @Override
    public void accept(WizardDisplayModelItem item) {
        this.checkRunning();
        if (item instanceof Item) {
            Item wizardItem = (Item)item;
            WizardDisplayModelItem root = null;
            while ((item = item.getParent()) != null) {
                root = item;
            }
            String location = String.format("wizard form %s", ((Form)root).getName());
            DisplayItem displayItem = new DisplayItem(wizardItem.getRendererAndValidator(), wizardItem.getValueKey(), location);
            this.getOrCreateTuple((String)wizardItem.getValueKey()).displayItems.add(displayItem);
        }
    }

    @Override
    public void accept(ExpertDisplayModelItem item) {
        this.checkRunning();
        if (item instanceof ExpertValueItem) {
            ExpertValueItem expertItem = (ExpertValueItem)item;
            ExpertDisplayModelItem root = item;
            while ((item = item.getParent()) != null) {
                root = item;
            }
            String location = root instanceof ExpertFormItem ? String.format("expert form %s", ((ExpertFormItem)root).getName()) : "[N/A]";
            DisplayItem displayItem = new DisplayItem(expertItem.getRendererAndInputValidator(), expertItem.getLogicModelItemName(), location);
            this.getOrCreateTuple((String)expertItem.getLogicModelItemName()).displayItems.add(displayItem);
        }
    }

    private void postProcess(@Nullable LogicModelItem item, @NonNull List<DisplayItem> displayItems) {
        assert (!(displayItems == null || item == null && displayItems.isEmpty()));
        if (item == null) {
            for (DisplayItem displayItem : displayItems) {
                this.notifyError("{} bound to unknown model item: %s.", displayItem, displayItem.lmk);
            }
        } else if (!(item.isReadonly() || item instanceof Module || item instanceof LogicModelItem.TableItem)) {
            List<String> pKeyTemplates;
            if (displayItems.isEmpty()) {
                this.notifyDebug("Logic model item %s is not referenced by any display item.", item.getName(), item.isReadonly());
            }
            if ((pKeyTemplates = item.getPersistenceKeyTemplates()).isEmpty()) {
                if (this.pKeyMandatoryForEditableItems) {
                    this.notifyError("Missing persistence key template for item: %s.", item.getName());
                } else {
                    this.notifyDebug("Editable logic model item %s has no pKey defined.", item.getName());
                }
            } else {
                for (String pKeyTemplate : pKeyTemplates) {
                    if (this.pKeyTemplatesSet.add(pKeyTemplate) || !this.duplicatePKeyForbidden) continue;
                    this.notifyError("Duplicated pKey found %s on item %s", pKeyTemplate, item.getName());
                }
            }
        }
        this.checkConverters(item, displayItems);
    }

    protected Map<String, ModelItemDTO> getDummyDataModel() {
        return new HashMap<String, ModelItemDTO>();
    }

    private @NonNull Class<?> inferSelectTargetType(Select item) {
        String dmk;
        assert (item != null);
        LogicModelItem.ProtectedMap dummyDataModel = new LogicModelItem.ProtectedMap(Collections.unmodifiableMap(this.getDummyDataModel()), true);
        OptionItemsDTO optItems = item.getOptionItems(dummyDataModel, dmk = item.getNameWithTableIndexShapes().replaceAll("#", "90000"));
        Set<String> languages = optItems.getLanguageCodes();
        if (languages.isEmpty()) {
            languages = Collections.singleton(null);
        }
        Class<?> targetType = null;
        for (String language : languages) {
            for (OptionItemDTO optItem : optItems.getOptionItems(language).values()) {
                Object value = optItem.getValue();
                if (value == null) continue;
                Class<?> valueType = value.getClass();
                if (targetType == null) {
                    targetType = valueType;
                    continue;
                }
                if (targetType.equals(valueType)) continue;
                this.notifyWarning("Select item %s has mixed value type.", item.getName());
                return Object.class;
            }
        }
        if (targetType == null) {
            this.notifyWarning("No value found for select item %s.", item.getName());
            return Object.class;
        }
        return targetType;
    }

    private void checkConverters(@Nullable LogicModelItem item, @NonNull List<DisplayItem> displayItems) {
        assert (!(displayItems == null || item == null && displayItems.isEmpty()));
        HashMap targetTypes = new HashMap();
        Class<?> selectTargetType = item instanceof Select ? this.inferSelectTargetType((Select)item) : null;
        Class<?> expectedType = this.getLogicItemExpectedType(item);
        for (DisplayItem displayItem : displayItems) {
            ArrayList<DisplayItem> sameTypeItems;
            Class<?> targetType = null;
            AbstractConverter<?> converter = displayItem.converter;
            if (converter instanceof SelectConverter) {
                if (selectTargetType == null) {
                    this.notifyWarning("%s: select converter bound to non-Select item.", displayItem);
                }
                targetType = selectTargetType;
            } else if (selectTargetType != null) {
                this.notifyDebug("%s: select item with custom converter.", displayItem);
            }
            if (targetType == null) {
                targetType = converter.getTargetType();
            }
            if (targetType == null) {
                this.notifyWarning("%s: converter do not define a target type.", converter);
                continue;
            }
            if (expectedType != null && !expectedType.isAssignableFrom(targetType)) {
                String msg = "%s: expected type (%s) does not match converter target type (%s).";
                Object[] fmt = new Object[]{displayItem, expectedType, targetType};
                if (!item.isReadonly()) {
                    this.notifyError(msg, fmt);
                } else {
                    this.notifyDebug(msg, fmt);
                }
            }
            if ((sameTypeItems = (ArrayList<DisplayItem>)targetTypes.get(targetType)) == null) {
                sameTypeItems = new ArrayList<DisplayItem>();
                targetTypes.put(targetType, sameTypeItems);
            }
            sameTypeItems.add(displayItem);
        }
        if (targetTypes.size() > 1) {
            StringBuilder sb = new StringBuilder("Several target type possible for item " + item.getName() + ":\n");
            for (Map.Entry entry : targetTypes.entrySet()) {
                sb.append("\t- ").append(entry.getKey()).append(":\n");
                for (DisplayItem displayItem : (List)entry.getValue()) {
                    sb.append("\t\t").append(displayItem).append("\n");
                }
            }
            this.notifyWarning(sb.toString(), new Object[0]);
        }
    }

    protected @Nullable Class<?> getLogicItemExpectedType(@NonNull LogicModelItem item) {
        return null;
    }

    private void done() {
        for (ModelTuple tuple : this.summaryMap.values()) {
            this.postProcess(tuple.item, tuple.displayItems);
        }
        this.running = false;
    }

    private ModelTuple getOrCreateTuple(String lmk) {
        assert (lmk != null);
        ModelTuple tuple = this.summaryMap.get(lmk);
        if (tuple == null) {
            tuple = new ModelTuple();
            this.summaryMap.put(lmk, tuple);
        }
        return tuple;
    }

    protected void notifyDebug(String warning, Object ... fmt) {
        if (warning == null) {
            throw new NullPointerException("Debug statement cannot be null.");
        }
        this.debugs.add(String.format(warning, fmt));
    }

    protected void notifyWarning(String warning, Object ... fmt) {
        if (warning == null) {
            throw new NullPointerException("Warning statement cannot be null.");
        }
        this.warnings.add(String.format(warning, fmt));
    }

    protected void notifyError(String error, Object ... fmt) {
        if (error == null) {
            throw new NullPointerException("Error statement cannot be null.");
        }
        this.errors.add(String.format(error, fmt));
    }

    public List<String> getDebugs() {
        return this.debugs;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void log() {
        if (!this.debugs.isEmpty()) {
            LOG.debug("{} debug statement(s) encountered while visiting the model: {}", (Object)this.debugs.size(), (Object)this.toString(this.debugs));
        }
        if (!this.warnings.isEmpty()) {
            LOG.warn("{} warning(s) encountered while visiting the model: {}", (Object)this.warnings.size(), (Object)this.toString(this.warnings));
        }
        if (!this.errors.isEmpty()) {
            LOG.error("{} error(s) encountered while visiting the model: {}", (Object)this.errors.size(), (Object)this.toString(this.errors));
        }
    }

    public void run(@NonNull Engine engine) {
        if (engine == null) {
            throw new NullPointerException("Engine cannot be null.");
        }
        this.start();
        engine.visit(this);
        engine.visit(this);
        engine.visit(this);
        this.done();
    }

    private String toString(List<String> statements) {
        assert (statements != null && !statements.isEmpty());
        return "\n- " + StringUtils.join(statements, (String)"\n- ");
    }

    private void checkRunning() {
        if (!this.running) {
            throw new IllegalStateException("Direct invocation of the visitor is forbidden, use run() instead.");
        }
    }

    private static class ModelTuple {
        LogicModelItem item;
        final List<DisplayItem> displayItems = new ArrayList<DisplayItem>();

        private ModelTuple() {
        }
    }

    private static final class DisplayItem {
        final AbstractConverter<?> converter;
        final String lmk;
        final String location;

        private DisplayItem(AbstractConverter<?> converter, String lmk, String location) {
            assert (converter != null && lmk != null && location != null);
            this.converter = converter;
            this.lmk = lmk;
            this.location = location;
        }

        public String toString() {
            return "[lmk=" + this.lmk + ", location=" + this.location + ", converter=" + String.valueOf(this.converter) + "]";
        }
    }
}

