/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.util;

import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceReadDTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EngineUtil {
    public static final String DMK_NOTNULL_MSG = "Data model key cannot be null.";
    private static int nextTableEntryStartIndex = 0;

    private EngineUtil() {
    }

    @Deprecated
    public static @NonNull String mergeModelKey(@NonNull String logicModelKey, @NonNull String dataModelKey) {
        StringBuilder result = new StringBuilder();
        StringTokenizer stLMK = new StringTokenizer(logicModelKey, ".");
        StringTokenizer stDMK = new StringTokenizer(dataModelKey, ".");
        boolean inSync = true;
        while (stDMK.hasMoreTokens() && inSync) {
            String dmkToken = stDMK.nextToken();
            if (dmkToken.charAt(0) >= '0' && dmkToken.charAt(0) <= '9') {
                if (result.length() > 0) {
                    result.append(".");
                }
                result.append(dmkToken);
                continue;
            }
            if (stLMK.hasMoreTokens()) {
                String lmkToken = stLMK.nextToken();
                inSync = dmkToken.equals(lmkToken);
                if (result.length() > 0) {
                    result.append(".");
                }
                result.append(lmkToken);
                continue;
            }
            inSync = false;
        }
        while (stLMK.hasMoreTokens()) {
            if (result.length() > 0) {
                result.append(".");
            }
            result.append(stLMK.nextToken());
        }
        return result.toString();
    }

    @Deprecated
    public static @NonNull String mergeModelKey(@NonNull LMK logicModelKey, @NonNull DMK dataModelKey) {
        return EngineUtil.mergeModelKey(logicModelKey.toExternalForm(), dataModelKey.toExternalForm());
    }

    @Deprecated
    public static boolean endsWithTableIndex(@Nullable String dataModelKey) {
        String s;
        if (dataModelKey == null) {
            return false;
        }
        int i = dataModelKey.lastIndexOf(46);
        String string = s = i < 0 ? dataModelKey : dataModelKey.substring(i + 1);
        if (s.isEmpty()) {
            return false;
        }
        return s.charAt(0) >= '0' && s.charAt(0) <= '9';
    }

    public static @NonNull String removeLastKeyPart(@NonNull String dataModelKey) {
        if (dataModelKey == null) {
            throw new NullPointerException(DMK_NOTNULL_MSG);
        }
        int i = dataModelKey.lastIndexOf(46);
        return i < 0 ? "" : dataModelKey.substring(0, i);
    }

    public static @NonNull String getLastKeyPart(@NonNull String dataModelKey) {
        int i = dataModelKey.lastIndexOf(46);
        return i < 0 ? dataModelKey : dataModelKey.substring(i + 1);
    }

    @Deprecated
    public static @NonNull String removeTableIndices(@NonNull String dataModelKey) {
        if (dataModelKey == null) {
            throw new NullPointerException(DMK_NOTNULL_MSG);
        }
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(dataModelKey, ".");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.charAt(0) >= '0' && s.charAt(0) <= '9') continue;
            if (result.length() > 0) {
                result.append(".");
            }
            result.append(s);
        }
        return result.toString();
    }

    @Deprecated
    public static @NonNull String getOuterTableRowDmk(@NonNull String dataModelKey) {
        if (dataModelKey == null) {
            throw new NullPointerException(DMK_NOTNULL_MSG);
        }
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(dataModelKey, ".");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            result.append(s);
            if (s.charAt(0) >= '0' && s.charAt(0) <= '9' && result.length() > 0) {
                return result.toString();
            }
            result.append(".");
        }
        return dataModelKey;
    }

    @Deprecated
    public static @NonNull String convertPersistenceKey(@NonNull String persistenceKeyTemplate, @NonNull String dataModelKey) {
        Objects.requireNonNull(persistenceKeyTemplate);
        Objects.requireNonNull(dataModelKey);
        Object persistenceKey = persistenceKeyTemplate;
        StringTokenizer stDMK = new StringTokenizer(dataModelKey, ".");
        int sharpPos = ((String)persistenceKey).indexOf(35);
        while (sharpPos > -1 && stDMK.hasMoreTokens()) {
            String s = stDMK.nextToken();
            if (s.charAt(0) >= '0' && s.charAt(0) <= '9') {
                persistenceKey = ((String)persistenceKey).substring(0, sharpPos) + s + ((String)persistenceKey).substring(sharpPos + 1);
            }
            sharpPos = ((String)persistenceKey).indexOf(35);
        }
        return persistenceKey;
    }

    public static @NonNull String convertPersistenceKey(@NonNull String persistenceKeyTemplate, @NonNull DMK dataModelKey) {
        return EngineUtil.convertPersistenceKey(persistenceKeyTemplate, dataModelKey.toExternalForm());
    }

    public static int getNextTableItemIndex(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull LogicModelItem.TableItem tableItem, @NonNull String dataModelKey) {
        int index;
        int result = EngineUtil.getNextTableEntryStartIndex();
        if (result <= (index = EngineUtil.maxTableIndex(dataModel, (LogicModelItem)((Object)tableItem), dataModelKey))) {
            result = index + 1;
        }
        for (LogicModelItem.TableItem tableItem2 : tableItem.getSharedTables()) {
            LogicModelItem sharedTableItem = (LogicModelItem)((Object)tableItem2);
            index = EngineUtil.maxTableIndex(dataModel, sharedTableItem, dataModelKey);
            if (result > index) continue;
            result = index + 1;
        }
        return result;
    }

    public static int getNextTableItemIndex(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull LogicModelItem.TableItem tableItem, @NonNull DMK dataModelKey) {
        return EngineUtil.getNextTableItemIndex(dataModel, tableItem, dataModelKey.toExternalForm());
    }

    public static @Nullable String getTableDataModelKey(@NonNull String tableEntryDMK) {
        boolean tableFound = false;
        String tableDMK = tableEntryDMK;
        while (!tableDMK.isEmpty()) {
            if (tableFound) {
                return tableDMK;
            }
            if (EngineUtil.endsWithTableIndex(tableDMK)) {
                tableFound = true;
            }
            tableDMK = EngineUtil.removeLastKeyPart(tableDMK);
        }
        return null;
    }

    public static @NonNull Map<String, PersistenceReadDTO> getMapOfPersistenceReadDTOs(List<PersistenceReadDTO> persistenceReadDTOs) {
        HashMap<String, PersistenceReadDTO> mappedPersistenceReadDTOs = new HashMap<String, PersistenceReadDTO>();
        for (PersistenceReadDTO dto : persistenceReadDTOs) {
            mappedPersistenceReadDTOs.put(dto.getDataModelKeyTemplate(), dto);
        }
        return mappedPersistenceReadDTOs;
    }

    private static int getNextTableEntryStartIndex() {
        if (nextTableEntryStartIndex == 0) {
            nextTableEntryStartIndex = ApplicationConfig.getInstance().getStartIndexForUserInsertedTableEntries();
        }
        return nextTableEntryStartIndex;
    }

    private static int maxTableIndex(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull LogicModelItem tableItem, @NonNull String dataModelKey) {
        int result = 0;
        String mergedName = EngineUtil.mergeModelKey(tableItem.getName(), dataModelKey);
        ModelItemDTO modelItemDTO = dataModel.get(mergedName);
        if (modelItemDTO != null && modelItemDTO.getValue() instanceof Set) {
            Set indices = (Set)modelItemDTO.getValue();
            for (Object indice : indices) {
                int index = Integer.parseInt(indice.toString());
                if (result >= index) continue;
                result = index;
            }
        }
        return result;
    }

    @Deprecated
    public static @NonNull Set<DMK> findRowDMKs(@NonNull Map<String, ModelItemDTO> dataModel, @NonNull DMK tableDMK) {
        HashSet<DMK> result = new HashSet<DMK>();
        for (Map.Entry<String, ModelItemDTO> entry : dataModel.entrySet()) {
            DMK rowEntryDMK = DMK.parse(entry.getKey());
            if (!tableDMK.containsChild(rowEntryDMK)) continue;
            DMK tableRowDMK = rowEntryDMK.getRowDMKForTableDMK(tableDMK);
            result.add(tableRowDMK);
        }
        return result;
    }
}

