/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeModelUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MergeModelUtil.class);
    public static final String ENCODING = "ISO-8859-1";
    public static final String SRC_ENCODING = "UTF-8";
    private static final String NEWLINE = "\n";
    private final File baseDir;
    private final File configurationFileName;
    private final StringBuilder logicStructure = new StringBuilder();
    private final StringBuilder wizardDisplayStructure = new StringBuilder();
    private final StringBuilder expertDisplayStructure = new StringBuilder();
    private String tmoLine;

    public MergeModelUtil(@Nullable File baseDir, @NonNull File configurationFile) {
        if (configurationFile == null) {
            throw new NullPointerException("Configuration file cannot be null.");
        }
        this.baseDir = baseDir;
        this.configurationFileName = configurationFile;
    }

    private void reset() {
        this.tmoLine = null;
        this.logicStructure.setLength(0);
        this.wizardDisplayStructure.setLength(0);
        this.expertDisplayStructure.setLength(0);
    }

    public void merge(@NonNull File outputFile) throws IOException {
        this.merge(outputFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(@NonNull File outputFile, boolean compress) throws IOException {
        if (outputFile == null) {
            throw new NullPointerException("Output file cannot be null.");
        }
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(outputFile));
            this.merge(os, compress);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public void merge(@NonNull OutputStream out, boolean compress) throws IOException {
        if (out == null) {
            throw new NullPointerException("Output stream cannot be null.");
        }
        if (compress) {
            out = new GZIPOutputStream(out);
        }
        this.merge(new OutputStreamWriter(out, ENCODING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(@NonNull Writer out) throws IOException {
        if (out == null) {
            throw new NullPointerException("Writer cannot be null.");
        }
        this.reset();
        LOG.info("Merging model using configuration file {} from base directory {}.", (Object)this.configurationFileName, this.baseDir != null ? this.baseDir : new File(".").getAbsolutePath());
        BufferedReader confReader = null;
        try {
            confReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.configurationFileName), SRC_ENCODING));
            LineIterator lineItr = new LineIterator(this, confReader){

                protected boolean isValidLine(String line) {
                    return !line.startsWith("*") && !line.startsWith("#");
                }
            };
            while (lineItr.hasNext()) {
                this.mergeInternal(new File(this.baseDir, (String)lineItr.next()));
            }
            this.generateFile(out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(confReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)confReader);
    }

    private void mergeInternal(@NonNull File file) throws IOException {
        block10: {
            boolean isExpertDisplay;
            boolean isWizardDisplay;
            boolean isLogic;
            block9: {
                File[] files;
                assert (file != null);
                isLogic = false;
                isWizardDisplay = false;
                isExpertDisplay = false;
                if (!file.isDirectory()) break block9;
                for (File file2 : files = file.listFiles()) {
                    this.mergeInternal(file2);
                }
                break block10;
            }
            if (!file.getName().endsWith(".xml")) break block10;
            LOG.debug("Merge file: " + file.getAbsolutePath());
            for (String line : FileUtils.readLines((File)file, (String)SRC_ENCODING)) {
                if (line.contains("<model-root name=")) {
                    this.tmoLine = line;
                }
                if (line.contains("<logic-model") || line.contains("</wizard-display-model") || line.contains("</expert-display-model")) {
                    isLogic = true;
                    isWizardDisplay = false;
                    isExpertDisplay = false;
                }
                if (line.contains("<wizard-display-model") || line.contains("</expert-display-model") || line.contains("</logic-model")) {
                    isLogic = false;
                    isWizardDisplay = true;
                    isExpertDisplay = false;
                }
                if (line.contains("<expert-display-model") || line.contains("</wizard-display-model") || line.contains("</logic-model")) {
                    isLogic = false;
                    isWizardDisplay = false;
                    isExpertDisplay = true;
                }
                if (line.contains("<?xml") || line.contains("<!DOCTYPE") || line.contains("<model-root") || line.contains("</model-root") || line.contains("logic-model") || line.contains("wizard-display-model") || line.contains("expert-display-model")) continue;
                if (isLogic) {
                    this.logicStructure.append(line).append(NEWLINE);
                }
                if (isWizardDisplay) {
                    this.wizardDisplayStructure.append(line).append(NEWLINE);
                }
                if (!isExpertDisplay) continue;
                this.expertDisplayStructure.append(line).append(NEWLINE);
            }
        }
    }

    private void generateFile(@NonNull Writer out) throws IOException {
        assert (out != null);
        try {
            out.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            out.write(this.tmoLine + NEWLINE);
            out.write("<logic-model>\n");
            out.write(this.logicStructure.toString());
            out.write("</logic-model>\n");
            out.write("<wizard-display-model>\n");
            out.write(this.wizardDisplayStructure.toString());
            out.write("</wizard-display-model>\n");
            out.write("<expert-display-model>\n");
            out.write(this.expertDisplayStructure.toString());
            out.write("</expert-display-model>\n");
            out.write("</model-root>\n");
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }
}

