/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AutoSetDefault
implements Validator {
    private final List<CalcItem> calcItems;
    private LogicModelItem selectItem;

    public AutoSetDefault(List<CalcItem> calcItems) {
        this.calcItems = calcItems;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.selectItem = logicModelItem;
        if (!(this.selectItem instanceof LogicModelItem.SelectItem)) {
            throw new InvalidModelException(this.getClass().getName() + " must be used within a select item");
        }
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        OptionItemsDTO oisDTO = ((Select)this.selectItem).getOptionItems(dataModel, dataModelKey);
        if (oisDTO != null && oisDTO.getOptionKeys().size() == 1) {
            OptionItemDTO oiDTO = oisDTO.get(oisDTO.getOptionKeys().iterator().next());
            modelItemDTO = modelItemDTO.clone(oiDTO.getValue());
        }
        return modelItemDTO;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<CalcItem> calcItems = new ArrayList<CalcItem>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add((CalcItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            AutoSetDefault result = new AutoSetDefault(calcItems);
            return new ClassObjectPair(AutoSetDefault.class, (Object)result);
        }
    }
}

