/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CalculateNewValueValidator
implements Validator {
    private final CalcItem[] calcItems;
    private boolean alwaysTouch = false;
    private final String noNewValueResult;

    public CalculateNewValueValidator(CalcItem[] calcItems) {
        this(calcItems, null);
    }

    public CalculateNewValueValidator(CalcItem[] calcItems, String noNewValueResult) {
        this.calcItems = (CalcItem[])calcItems.clone();
        this.noNewValueResult = noNewValueResult;
    }

    public CalculateNewValueValidator(CalcItem[] calcItems, boolean alwaysTouch) {
        this(calcItems);
        this.alwaysTouch = alwaysTouch;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        ModelItemDTO result = modelItemDTO;
        FastStack stack = new FastStack();
        for (CalcItem calcItem : this.calcItems) {
            try {
                calcItem.evaluate(dataModel, stack, dataModelKey);
            }
            catch (RuntimeException rte) {
                throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
            }
        }
        Object calcItemsResult = !stack.isEmpty() ? stack.pop() : null;
        boolean newValue = false;
        if (this.noNewValueResult == null) {
            newValue = calcItemsResult != null;
        } else {
            boolean bl = newValue = !this.noNewValueResult.equals(calcItemsResult);
        }
        if (newValue) {
            result = result.clone(calcItemsResult);
            if (this.alwaysTouch) {
                result.setTouched();
            }
        }
        return result;
    }
}

