/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CopyTableItemFromComboSelect
implements Validator {
    private final Reference[] tableItemSources;
    private final Reference selectChoosenItem;

    public CopyTableItemFromComboSelect(Reference[] tableItemSources, Reference selectChoosenItem) {
        this.tableItemSources = (Reference[])tableItemSources.clone();
        this.selectChoosenItem = selectChoosenItem;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (Reference tableItemSource : this.tableItemSources) {
            tableItemSource.registerListenerOnReference(logicModel, logicModelItem, true);
        }
        this.selectChoosenItem.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        ModelItemDTO selectedItem = dataModel.get(EngineUtil.mergeModelKey(this.selectChoosenItem.getName(), dataModelKey));
        if (selectedItem == null || selectedItem.getValue() == null) {
            return modelItemDTO;
        }
        for (Reference tableItemSource : this.tableItemSources) {
            LogicModelItem lmi = tableItemSource.getReference();
            if (lmi == null) {
                throw new IllegalArgumentException(tableItemSource.getName() + " must be within a table item");
            }
            while (!(lmi instanceof LogicModelItem.TableItem)) {
                lmi = lmi.getParent();
            }
            String selectedTableItemKey = EngineUtil.mergeModelKey(lmi.getName(), dataModelKey) + "." + String.valueOf(selectedItem.getValue());
            ModelItemDTO miDTO = dataModel.get(EngineUtil.mergeModelKey(tableItemSource.getName(), selectedTableItemKey));
            if (miDTO == null) continue;
            return miDTO;
        }
        return modelItemDTO;
    }
}

