/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Delete
implements Validator {
    private final List<CalcItem> calcItems;
    private final boolean booleanExpression;
    private final boolean applyIfNull;
    private final String messageKey;
    private LogicModelItem lmi;

    public Delete(List<CalcItem> calcItems, boolean booleanExpression, boolean applyIfNull, String messageKey) {
        this.calcItems = calcItems;
        this.booleanExpression = booleanExpression;
        this.applyIfNull = applyIfNull;
        this.messageKey = messageKey;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
        this.lmi = logicModelItem;
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        if (dataModel.allowActiveValidations()) {
            Object value;
            if (this.calcItems != null && !this.calcItems.isEmpty()) {
                FastStack stack = new FastStack();
                for (CalcItem calcItem : this.calcItems) {
                    try {
                        calcItem.evaluate(dataModel, stack, dataModelKey);
                    }
                    catch (RuntimeException rte) {
                        throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
                    }
                }
                value = !stack.isEmpty() ? stack.pop() : null;
            } else {
                value = modelItemDTO.getValue();
            }
            if (value == null && this.applyIfNull || value instanceof Boolean && (Boolean)value == this.booleanExpression) {
                boolean deleteThisValue;
                boolean deleteSubValues = this.lmi.deleteSubValues(dataModel, dataModelKey, false, null);
                boolean bl = deleteThisValue = modelItemDTO.getValue() != null;
                if (deleteThisValue) {
                    modelItemDTO = modelItemDTO.clone(null);
                }
                if (this.messageKey != null && !this.messageKey.isEmpty()) {
                    boolean showMessage;
                    if (deleteSubValues) {
                        showMessage = true;
                    } else if (this.lmi instanceof Module || this.lmi instanceof LogicModelItem.TableItem) {
                        showMessage = false;
                    } else {
                        boolean bl2 = showMessage = deleteThisValue && !this.lmi.isReadonly() && modelItemDTO.isTouched();
                    }
                    if (showMessage) {
                        dataModel.addDeleteWarning(new MessageItemDTO(this.messageKey, null, 2));
                    }
                }
            }
        }
        return modelItemDTO;
    }

    public static class XMLFactory
    implements ElementParser {
        private final boolean booleanExpression;

        public XMLFactory(boolean booleanExpression) {
            this.booleanExpression = booleanExpression;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Boolean b;
            String message;
            ArrayList<CalcItem> calcItems = new ArrayList<CalcItem>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add((CalcItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (element.getAttributeValue("ref") != null) {
                throw new ElementParserException("ref attribute is deprecated in delete validators (" + element.getAttributeValue("ref") + ")");
            }
            boolean applyIfNull = false;
            String applyIfNullStr = element.getAttribute("apply-if-null");
            if (applyIfNullStr != null) {
                applyIfNull = Boolean.valueOf(applyIfNullStr);
            }
            if ((message = element.getAttributeValue("message")) != null && message.isEmpty()) {
                message = null;
            }
            if (message == null && !(b = Boolean.valueOf(element.getAttributeValue("no-message"))).booleanValue()) {
                StringBuilder sb = new StringBuilder(element.getParent().getName());
                sb.append(" (");
                sb.append(element.getParent().getAttribute("name"));
                sb.append(")");
                sb.append(" - Delete Validator: ");
                throw new ElementParserException(sb.toString() + "no-message attribute must be true, if no message is defined");
            }
            Delete result = new Delete(calcItems, this.booleanExpression, applyIfNull, message);
            return new ClassObjectPair(Delete.class, (Object)result);
        }
    }
}

