/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DeleteTableEntry
implements Validator {
    private final CalcItem[] calcItems;
    private final String messageKey;
    private LogicModelItem lmi;

    public DeleteTableEntry(CalcItem[] calcItems, String messageKey) {
        this.calcItems = (CalcItem[])calcItems.clone();
        this.messageKey = messageKey;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
        this.lmi = logicModelItem;
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        ModelItemDTO result = modelItemDTO;
        if (dataModel.allowActiveValidations() && modelItemDTO.getValue() instanceof Set) {
            HashSet workSet = new HashSet((Set)modelItemDTO.getValue());
            Iterator i = workSet.iterator();
            while (i.hasNext()) {
                String tableEntryDMK = dataModelKey + "." + i.next().toString();
                Object value = null;
                if (this.calcItems != null && this.calcItems.length > 0) {
                    FastStack stack = new FastStack();
                    for (CalcItem calcItem : this.calcItems) {
                        try {
                            calcItem.evaluate(dataModel, stack, tableEntryDMK);
                        }
                        catch (RuntimeException rte) {
                            throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
                        }
                    }
                    Object object = value = !stack.isEmpty() ? stack.pop() : null;
                }
                if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
                this.lmi.deleteValue(dataModel, tableEntryDMK);
                i.remove();
                if (!modelItemDTO.isTouched() || this.messageKey == null || this.messageKey.isEmpty()) continue;
                dataModel.addDeleteWarning(new MessageItemDTO(this.messageKey, null, 2));
            }
            result = modelItemDTO.clone(workSet);
        }
        return result;
    }
}

