/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.CompareUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GenericCompareValidator
implements Validator {
    private final CompareUtil.Operator operator;
    private final List<CalcItem> calcItems;
    private final Object constant;
    private final boolean autoCorrect;
    private final boolean warning;
    private final String messageKey;

    public GenericCompareValidator(CompareUtil.Operator operator, Object rhs, boolean autoCorrect, boolean warning, String messageKey) {
        this(operator, null, rhs, autoCorrect, warning, messageKey);
    }

    public GenericCompareValidator(CompareUtil.Operator operator, List<CalcItem> rhsCalcItems, boolean autoCorrect, boolean warning, String messageKey) {
        this(operator, rhsCalcItems, null, autoCorrect, warning, messageKey);
    }

    private GenericCompareValidator(CompareUtil.Operator operator, List<CalcItem> calcItems, Object constant, boolean autoCorrect, boolean warning, String messageKey) {
        if (operator == null) {
            throw new NullPointerException("Operator cannot be null.");
        }
        if (calcItems == null && constant == null) {
            throw new NullPointerException("Either a calc-items list or a constant value to compare must be given.");
        }
        if (calcItems != null && constant != null) {
            throw new IllegalArgumentException("Cannot specify calc-items list and constant value to compare at the same time.");
        }
        if (messageKey == null && !autoCorrect) {
            throw new IllegalArgumentException("Validation message key must be set if auto-correct is disabled.");
        }
        this.operator = operator;
        this.calcItems = calcItems;
        this.constant = constant;
        this.autoCorrect = autoCorrect;
        this.warning = warning;
        this.messageKey = messageKey;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        if (this.calcItems != null) {
            for (CalcItem ci : this.calcItems) {
                if (ci instanceof Reference) {
                    ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                    continue;
                }
                if (!(ci instanceof ComplexCalcItem)) continue;
                ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
            }
        }
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        Boolean success;
        Object rhs;
        Object lhs = modelItemDTO.getValue();
        if (this.calcItems != null) {
            FastStack stack = new FastStack();
            for (CalcItem calcItem : this.calcItems) {
                try {
                    calcItem.evaluate(dataModel, stack, dataModelKey);
                }
                catch (RuntimeException rte) {
                    throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
                }
            }
            rhs = !stack.isEmpty() ? stack.pop() : null;
        } else {
            assert (this.constant != null);
            rhs = this.constant;
        }
        ModelItemDTO result = modelItemDTO;
        try {
            success = CompareUtil.compare(this.operator, lhs, rhs, false);
        }
        catch (RuntimeException rte) {
            throw new RuntimeException("Error comparing values on item " + dataModelKey, rte);
        }
        if (success != null && !success.booleanValue()) {
            int messageType;
            int newState;
            if (this.autoCorrect) {
                result = result.clone(rhs);
                newState = result.getState();
                messageType = 2;
            } else if (this.warning) {
                newState = 2;
                messageType = 2;
            } else {
                newState = 4;
                messageType = 4;
            }
            result = result.clone(newState);
            if (this.messageKey != null) {
                result = result.clone(this.messageKey, rhs, messageType);
            }
        }
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public static final String DEFAULT_MIN_INFO_KEY = "info.value.min.default";
        public static final String DEFAULT_MIN_ERROR_KEY = "error.value.min.default";
        public static final String DEFAULT_MIN_WARNING_KEY = "warning.value.min.default";
        public static final String DEFAULT_MAX_INFO_KEY = "info.value.max.default";
        public static final String DEFAULT_MAX_ERROR_KEY = "error.value.max.default";
        public static final String DEFAULT_MAX_WARNING_KEY = "warning.value.max.default";
        public static final XMLFactory MIN_FACTORY = new XMLFactory(CompareUtil.Operator.GREATER_OR_EQUAL, "info.value.min.default", "warning.value.min.default", "error.value.min.default");
        public static final XMLFactory MIN_STRICT_FACTORY = new XMLFactory(CompareUtil.Operator.GREATER, "info.value.min.default", "warning.value.min.default", "error.value.min.default");
        public static final XMLFactory MAX_FACTORY = new XMLFactory(CompareUtil.Operator.SMALLER_OR_EQUAL, "info.value.max.default", "warning.value.max.default", "error.value.max.default");
        public static final XMLFactory MAX_STRICT_FACTORY = new XMLFactory(CompareUtil.Operator.SMALLER, "info.value.max.default", "warning.value.max.default", "error.value.max.default");
        private final CompareUtil.Operator operator;
        private final String defaultWarningKey;
        private final String defaultErrorKey;
        private final String defaultInfoKey;

        public XMLFactory(@NonNull CompareUtil.Operator operator, String defaultInfoKey, String defaultWarningKey, String defaultErrorKey) {
            if (operator == null) {
                throw new NullPointerException("Operator cannot be null.");
            }
            this.operator = operator;
            this.defaultInfoKey = defaultInfoKey;
            this.defaultWarningKey = defaultWarningKey;
            this.defaultErrorKey = defaultErrorKey;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            GenericCompareValidator result;
            ArrayList<CalcItem> calcs = new ArrayList<CalcItem>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcs.add((CalcItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            boolean useAutoCorrect = Boolean.valueOf(element.getAttributeValue("autocorrect"));
            boolean noMessage = Boolean.valueOf(element.getAttribute("no-message"));
            boolean isWarning = Boolean.valueOf(element.getAttributeValue("warning"));
            String message = element.getAttributeValue("message");
            if (message == null && !noMessage) {
                message = useAutoCorrect ? this.defaultInfoKey : (isWarning ? this.defaultWarningKey : this.defaultErrorKey);
            }
            if (message == null) {
                useAutoCorrect = true;
            }
            if (!calcs.isEmpty()) {
                result = new GenericCompareValidator(this.operator, calcs, useAutoCorrect, isWarning, message);
            } else {
                if (element.getAttributeValue("value") == null) {
                    throw new ElementParserException();
                }
                String sValue = element.getAttributeValue("value");
                Number tmpConstant = sValue.indexOf(46) != -1 ? (Number)Double.valueOf(sValue) : (Number)Long.valueOf(sValue);
                result = new GenericCompareValidator(this.operator, tmpConstant, useAutoCorrect, isWarning, message);
            }
            return new ClassObjectPair(GenericCompareValidator.class, (Object)result);
        }
    }
}

