/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.validators.Mandatory;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GenericValidator
implements Validator {
    private final List<CalcItem> calcItems;
    private final boolean warning;
    private final String messageKey;
    private static final String DEFAULT_WARNING_KEY = "warning.missing.data.default";
    private static final String DEFAULT_ERROR_KEY = "error.missing.data.default";
    private final String messageRef;

    public GenericValidator(List<CalcItem> calcItems, boolean warning, String messageKey, String messageRef) {
        this.calcItems = calcItems;
        this.warning = warning;
        this.messageKey = messageKey;
        this.messageRef = messageRef;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        Object value;
        FastStack stack = new FastStack();
        for (CalcItem calcItem : this.calcItems) {
            try {
                calcItem.evaluate(dataModel, stack, dataModelKey);
            }
            catch (RuntimeException rte) {
                throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
            }
        }
        Object object = value = !stack.isEmpty() ? stack.pop() : null;
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            ModelItemDTO dto;
            if (this.messageRef != null && (dto = dataModel.get(EngineUtil.mergeModelKey(this.messageRef, dataModelKey))) != null) {
                value = dto.getValue();
            }
            if (this.warning) {
                msg = this.messageKey == null ? DEFAULT_WARNING_KEY : this.messageKey;
                modelItemDTO = modelItemDTO.clone(2, msg, value, 2);
            } else {
                msg = this.messageKey == null ? DEFAULT_ERROR_KEY : this.messageKey;
                modelItemDTO = modelItemDTO.clone(4, msg, value, 4);
            }
        }
        return modelItemDTO;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<CalcItem> calcItems = new ArrayList<CalcItem>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add((CalcItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String tmpMessageKey = element.getAttributeValue("message");
            String messageRef = element.getAttributeValue("message-ref");
            boolean tmpWarning = false;
            if (element.getAttribute("warning") != null) {
                tmpWarning = Boolean.valueOf(element.getAttributeValue("warning"));
            }
            GenericValidator result = new GenericValidator(calcItems, tmpWarning, tmpMessageKey, messageRef);
            return new ClassObjectPair(Mandatory.class, (Object)result);
        }
    }
}

