/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.calcitems.AbsRef;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class IfThenElse
implements ComplexCalcItem {
    private final List<CalcItem> testItems;
    private final List<CalcItem> thenItems;
    private final List<CalcItem> elseItems;
    private final AbsRef testRef;

    private IfThenElse(List<CalcItem> testItems, List<CalcItem> thenItems, List<CalcItem> elseItems, AbsRef testRef) {
        this.testItems = testItems;
        this.thenItems = thenItems;
        this.elseItems = elseItems;
        this.testRef = testRef;
    }

    @Override
    public void evaluate(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        String testDmk;
        ModelItemDTO testResultItem;
        Object testResult = this.testRef != null ? ((testResultItem = dataModel.get(testDmk = EngineUtil.mergeModelKey(this.testRef.getName(), dataModelKey))) != null ? testResultItem.getValue() : null) : this.evaluateFirstResult(dataModel, dataModelKey, this.testItems);
        if (Boolean.TRUE.equals(testResult)) {
            this.performEvaluate(dataModel, stack, dataModelKey, this.thenItems);
        } else {
            this.performEvaluate(dataModel, stack, dataModelKey, this.elseItems);
        }
    }

    private Object evaluateFirstResult(LogicModelItem.ProtectedMap dataModel, String dataModelKey, List<CalcItem> calcItems) {
        FastStack stack = new FastStack();
        this.performEvaluate(dataModel, stack, dataModelKey, calcItems);
        return !stack.isEmpty() ? stack.pop() : null;
    }

    private void performEvaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey, List<CalcItem> calcItems) {
        for (CalcItem ci : calcItems) {
            try {
                ci.evaluate(dataModel, stack, dataModelKey);
            }
            catch (RuntimeException rte) {
                throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
            }
        }
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.doInitializeReferences(this.testItems, logicModel, logicModelItem);
        this.doInitializeReferences(this.thenItems, logicModel, logicModelItem);
        this.doInitializeReferences(this.elseItems, logicModel, logicModelItem);
        this.doInitializeReferences(this.testRef, logicModel, logicModelItem);
    }

    private void doInitializeReferences(CalcItem calcItem, Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        if (calcItem != null) {
            if (calcItem instanceof Reference) {
                ((Reference)((Object)calcItem)).registerListenerOnReference(logicModel, logicModelItem, false);
            } else if (calcItem instanceof ComplexCalcItem) {
                ((ComplexCalcItem)calcItem).initializeReferences(logicModel, logicModelItem);
            }
        }
    }

    private void doInitializeReferences(List<CalcItem> calcItems, Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        if (calcItems != null) {
            for (CalcItem calcItem : calcItems) {
                this.doInitializeReferences(calcItem, logicModel, logicModelItem);
            }
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List<CalcItem> testItems = null;
            List<CalcItem> thenItems = null;
            List<CalcItem> elseItems = null;
            IfThenElse result = null;
            String testRefAttr = element.getAttribute("test");
            AbsRef testRef = testRefAttr != null ? new AbsRef(testRefAttr) : null;
            for (Element child : element.getChildren()) {
                String childName = child.getName();
                if (childName.equals("test")) {
                    if (testRef != null) {
                        throw new ElementParserException("Cannot specify the 'test' attribute and the 'test' child element at the same time.");
                    }
                    this.duplicateCheck(testItems, childName);
                    testItems = this.parseChildItems(child, factory);
                    continue;
                }
                if (childName.equals("then")) {
                    this.duplicateCheck(thenItems, childName);
                    thenItems = this.parseChildItems(child, factory);
                    continue;
                }
                if (childName.equals("else")) {
                    this.duplicateCheck(elseItems, childName);
                    elseItems = this.parseChildItems(child, factory);
                    continue;
                }
                throw new ElementParserException("Unexpected child element: " + childName);
            }
            if (testRef == null && (testItems == null || testItems.isEmpty())) {
                throw new ElementParserException("Either a test reference or a non-empty test element must be specified.");
            }
            if (thenItems == null || thenItems.isEmpty()) {
                throw new ElementParserException("A non-empty 'then' element must be specified.");
            }
            if (elseItems == null) {
                elseItems = Collections.emptyList();
            }
            result = new IfThenElse(testItems, thenItems, elseItems, testRef);
            return new ClassObjectPair(IfThenElse.class, (Object)result);
        }

        private void duplicateCheck(Object elt, String name) throws ElementParserException {
            if (elt != null) {
                throw new ElementParserException("Cannot specify element '" + name + "' more than once.");
            }
        }

        private List<CalcItem> parseChildItems(Element element, ParserFactory factory) throws ElementParserException {
            List children = element.getChildren();
            ArrayList<CalcItem> childItems = new ArrayList<CalcItem>(children.size());
            for (Element child : children) {
                try {
                    String childName = child.getName();
                    ElementParser parser = factory.getParser(childName);
                    ClassObjectPair cob = parser.parse(child, factory);
                    Object childObject = cob.getObject();
                    if (!(childObject instanceof CalcItem)) {
                        throw new ElementParserException("Unexpected child element: " + childName);
                    }
                    childItems.add((CalcItem)childObject);
                }
                catch (ParserNotRegisteredException e) {
                    throw new ElementParserException((Throwable)e);
                }
            }
            return childItems;
        }
    }
}

