/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.PreselectionValidator;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Transparent
implements Validator,
PreselectionValidator {
    private final boolean booleanExpression;
    private final List<CalcItem> calcItems;
    private final boolean applyIfNull;

    public Transparent(List<CalcItem> calcItems, boolean booleanExpression, boolean applyIfNull) {
        this.calcItems = calcItems;
        this.booleanExpression = booleanExpression;
        this.applyIfNull = applyIfNull;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
    }

    public List<CalcItem> getCalcItems() {
        return this.calcItems;
    }

    @Override
    public boolean getBooleanExpression() {
        return this.booleanExpression;
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        Object value;
        FastStack stack = new FastStack();
        for (CalcItem calcItem : this.calcItems) {
            try {
                calcItem.evaluate(dataModel, stack, dataModelKey);
            }
            catch (RuntimeException rte) {
                throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
            }
        }
        Object object = value = !stack.isEmpty() ? stack.pop() : null;
        if (value == null && this.applyIfNull || value instanceof Boolean && (Boolean)value == this.booleanExpression) {
            modelItemDTO = modelItemDTO.clone(11);
        }
        return modelItemDTO;
    }

    @Override
    public Reference getPreselectItemReference() {
        CalcItem ci;
        if (this.getCalcItems().size() == 1 && (ci = this.getCalcItems().iterator().next()) instanceof Reference) {
            return (Reference)((Object)ci);
        }
        return null;
    }

    public static class XMLFactory
    implements ElementParser {
        private final boolean booleanExpression;

        public XMLFactory(boolean booleanExpression) {
            this.booleanExpression = booleanExpression;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<CalcItem> calcItems = new ArrayList<CalcItem>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add((CalcItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            boolean applyIfNull = false;
            String applyIfNullStr = element.getAttribute("apply-if-null");
            if (applyIfNullStr != null) {
                applyIfNull = Boolean.valueOf(applyIfNullStr);
            }
            Transparent result = new Transparent(calcItems, this.booleanExpression, applyIfNull);
            return new ClassObjectPair(Transparent.class, (Object)result);
        }
    }
}

