/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.SpannableItem;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.presentation.common.util.Render;
import ch.dvbern.tax.common.presentation.common.util.RenderBuilder;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Button
extends WizardDisplayModelItem
implements SpannableItem {
    private static final Logger LOG = LoggerFactory.getLogger(Button.class);
    private final int colspan;
    private final String uri;
    private final String name;
    private final String dmk;
    private final String dmkValue;
    private final String icon;
    private final String target;
    private final String tooltip;
    private final String viewId;
    private final String statusId;
    private final String styleClass;
    private final String stateKey;
    private final Integer width;
    private final Integer height;
    private final boolean transparentIfView;
    private final boolean ajax;
    private final Render reRender;
    private final FontDTO fontDTO;

    public Button(String uri, String name, String dmk, String dmkValue, String icon, String target, int colspan, boolean transparentIfView, Integer width, Integer height, Render reRender, boolean ajax, String viewId, String statusId, String styleClass, String stateKey, FontDTO fontDTO, String tooltip) {
        this.uri = uri;
        this.name = name;
        this.dmk = dmk;
        this.icon = icon;
        this.target = target;
        this.colspan = colspan;
        this.transparentIfView = transparentIfView;
        this.width = width;
        this.height = height;
        this.dmkValue = dmkValue;
        this.reRender = reRender;
        this.ajax = ajax;
        this.viewId = viewId;
        this.statusId = statusId;
        this.styleClass = styleClass;
        this.stateKey = stateKey;
        this.fontDTO = fontDTO;
        this.tooltip = tooltip;
        LOG.debug("BUTTON: uri=" + uri + ", name=" + name + ", dmk=" + dmk + ", dmkValue=" + dmkValue + ", target=" + target + ", reRender=" + String.valueOf(reRender) + ", viewID:\u00a0" + viewId + ", styleClass=" + styleClass + ", tooltip=" + tooltip);
    }

    public List<WizardDisplayModelItem> getChildren() {
        return null;
    }

    @Override
    public int getColspan() {
        return this.colspan;
    }

    public @Nullable FontDTO getFontDTO() {
        return this.fontDTO;
    }

    @Override
    public WizardDisplayInfoDTO.ButtonDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        String s2;
        String s;
        int state = 1;
        if (this.stateKey != null) {
            ModelItemDTO stateItem = dataModel.get(EngineUtil.mergeModelKey(this.stateKey, key));
            if (stateItem == null || stateItem.getState() == 12) {
                return null;
            }
            if (stateItem.getState() == 11) {
                state = 11;
            }
        }
        if ((s = this.dmk) != null && !s.isEmpty()) {
            s = EngineUtil.mergeModelKey(s, key);
        }
        if ((s2 = this.dmkValue) != null && !s2.isEmpty()) {
            s2 = EngineUtil.mergeModelKey(s2, key);
        }
        if (this.getParent() instanceof Form) {
            return new WizardDisplayInfoDTO.ButtonDTO(this.getUniqueItemIdentifier(), this.uri, this.name, s, s2, this.icon, this.target, this.colspan, this.transparentIfView, this.width, this.height, this.reRender, this.ajax, this.viewId, this.statusId, this.styleClass, this.fontDTO, state, this.tooltip);
        }
        Row row = (Row)this.getParent();
        int index = row.getIndex(this);
        int corrColspan = this.colspan;
        for (int i = 0; i < this.colspan; ++i) {
            ColDef coldef = ((Section)row.getParent()).getColdefs().get(index + i);
            WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = coldef.getFormInfo(dataModel, key);
            if (cdiDTO.getState() != 12) continue;
            --corrColspan;
        }
        if (corrColspan <= 0) {
            return null;
        }
        return new WizardDisplayInfoDTO.ButtonDTO(this.getUniqueItemIdentifier(), this.uri, this.name, s, s2, this.icon, this.target, corrColspan, this.transparentIfView, this.width, this.height, this.reRender, this.ajax, this.viewId, this.statusId, this.styleClass, this.fontDTO, state, this.tooltip);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            FontDTO fontDTO = null;
            List elements = element.getChildren();
            for (Element elt : elements) {
                try {
                    ElementParser parser = factory.getParser(elt.getName());
                    Object obj = parser.parse(elt, factory).getObject();
                    if (obj instanceof FontDTO) {
                        if (fontDTO != null) {
                            throw new ElementParserException("Only a single font element expected.");
                        }
                        fontDTO = (FontDTO)obj;
                        continue;
                    }
                    throw new ElementParserException("Unexpected child type: " + String.valueOf(obj.getClass()));
                }
                catch (ParserNotRegisteredException e) {
                    throw new ElementParserException("Cannot locate parser for " + elt.getName());
                }
            }
            String uri = element.getAttributeValue("URI");
            if (uri == null || uri.isEmpty()) {
                throw new ElementParserException("missing URI argument for " + String.valueOf(element));
            }
            String name = element.getAttributeValue("name");
            if (name == null || name.isEmpty()) {
                throw new ElementParserException("missing name argument for " + String.valueOf(element));
            }
            int colspan = element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1;
            boolean transparentIfEdit = false;
            if (element.getAttribute("transparent-if-view") != null) {
                transparentIfEdit = Boolean.valueOf(element.getAttributeValue("transparent-if-view"));
            }
            Integer width = null;
            Integer height = null;
            if (element.getAttribute("width") != null) {
                width = Integer.valueOf(element.getAttributeValue("width"));
            }
            if (element.getAttribute("height") != null) {
                height = Integer.valueOf(element.getAttributeValue("height"));
            }
            Render reRender = RenderBuilder.create(element.getAttributeValue("reRender")).build();
            boolean ajax = true;
            if (element.getAttribute("ajax") != null) {
                ajax = Boolean.parseBoolean(element.getAttributeValue("ajax"));
            }
            return new ClassObjectPair(Button.class, (Object)new Button(uri, name, element.getAttributeValue("dmk"), element.getAttributeValue("dmkValue"), element.getAttributeValue("icon"), element.getAttributeValue("target"), colspan, transparentIfEdit, width, height, reRender, ajax, element.getAttributeValue("viewId"), element.getAttributeValue("statusId"), element.getAttributeValue("styleClass"), element.getAttributeValue("state"), fontDTO, WizardDisplayUtil.getString(element.getAttributeValue("tooltip"), name)));
        }
    }
}

