/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ColDef
extends WizardDisplayModelItem {
    public static final String UNDEFINED_WIDTH = "*";
    private final String width;
    private final @Nullable LMK stateKey;
    private final String header;
    private String align;
    private final List<LabelAddOn> headerAddOns;
    private final boolean filter;
    private final String filterPlaceholder;
    private final String styleClass;

    public ColDef(String width, @Nullable LMK stateKey, String header, List<LabelAddOn> headerAddOns, boolean filter, String filterPlaceholder, @Nullable String styleClass) {
        this.width = width;
        this.stateKey = stateKey;
        this.header = header;
        this.headerAddOns = headerAddOns;
        this.filter = filter;
        this.filterPlaceholder = filterPlaceholder;
        this.styleClass = styleClass;
    }

    public List<WizardDisplayModelItem> getChildren() {
        return Collections.emptyList();
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getWidth() {
        return this.width;
    }

    public @Nullable String getStyleClass() {
        return this.styleClass;
    }

    public @Nullable LMK getStateKey() {
        return this.stateKey;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.stateKey != null && logicModelItems.get(this.stateKey.toExternalForm()) == null) {
            throw new InvalidModelException("invalid state-reference in ColDef stateKey=" + String.valueOf(this.stateKey));
        }
        if (this.headerAddOns != null) {
            for (LabelAddOn labelAddOn : this.headerAddOns) {
                labelAddOn.additionalInitializeWizardDisplayModel(logicModelItems);
            }
        }
    }

    @Override
    public WizardDisplayInfoDTO.ColDefItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO> labelAddOnDTOs = new ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO>();
        if (this.headerAddOns != null) {
            for (LabelAddOn labelAddOn : this.headerAddOns) {
                WizardDisplayInfoDTO.LabelAddOnDTO formInfo = labelAddOn.getFormInfo(dataModel, key);
                if (formInfo == null) continue;
                labelAddOnDTOs.add(formInfo);
            }
        }
        if (labelAddOnDTOs.isEmpty()) {
            labelAddOnDTOs = null;
        }
        if (this.stateKey != null) {
            DMK stateDMK = DMK.parse(key).merge(this.stateKey);
            int state = dataModel.getWithoutTouch(stateDMK.toExternalForm()).getState();
            return new WizardDisplayInfoDTO.ColDefItemDTO(this.getUniqueItemIdentifier(), state, this.width, this.header, labelAddOnDTOs, this.align, this.filter, this.filterPlaceholder, this.styleClass);
        }
        return new WizardDisplayInfoDTO.ColDefItemDTO(this.getUniqueItemIdentifier(), 1, this.width, this.header, labelAddOnDTOs, this.align, this.filter, this.filterPlaceholder, this.styleClass);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<LabelAddOn> labelAddOns = new ArrayList<LabelAddOn>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add((LabelAddOn)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (labelAddOns.isEmpty() && element.getAttribute("header-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("header-add-on")));
            }
            if (labelAddOns.isEmpty()) {
                labelAddOns = null;
            }
            return new ClassObjectPair(ColDef.class, (Object)new ColDef(element.getAttribute("width") != null ? element.getAttributeValue("width") : ColDef.UNDEFINED_WIDTH, LMK.parse(element.getAttributeValue("state")), element.getAttributeValue("header"), labelAddOns, WizardDisplayUtil.getBoolean(element.getAttributeValue("filter"), false), element.getAttributeValue("filter-placeholder"), element.getAttributeValue("styleClass")));
        }
    }
}

