/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Header
extends WizardDisplayModelItem {
    private final @NonNull String name;
    private final int colspan;
    private final @Nullable List<String> stateKeyList;
    private final @Nullable List<LabelAddOn> headerAddOns;

    public Header(String name, int colspan, String stateKeys, List<LabelAddOn> headerAddOns) {
        if (name == null || name.isEmpty()) {
            throw new IllegalStateException("name may not be null!");
        }
        this.name = name;
        this.colspan = colspan;
        ArrayList<String> newStateKeyList = null;
        if (stateKeys != null && !stateKeys.isEmpty()) {
            newStateKeyList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(stateKeys, ",");
            while (st.hasMoreTokens()) {
                newStateKeyList.add(st.nextToken().trim());
            }
        }
        this.stateKeyList = newStateKeyList;
        this.headerAddOns = headerAddOns;
    }

    public @Nullable List<WizardDisplayModelItem> getChildren() {
        return null;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public int getColspan() {
        return this.colspan;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(@NonNull Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.stateKeyList != null) {
            for (String string : this.stateKeyList) {
                if (logicModelItems.get(string) != null) continue;
                throw new InvalidModelException("invalid state-reference in label (key=" + string + ")");
            }
        }
        if (this.headerAddOns != null) {
            for (Object object : this.headerAddOns) {
                LabelAddOn element = (LabelAddOn)object;
                element.additionalInitializeWizardDisplayModel(logicModelItems);
            }
        }
    }

    private int getState(WizardDisplayModelItem.ProtectedMap dataModel, @NonNull String key) {
        int state = 1;
        if (this.stateKeyList != null) {
            for (String element : this.stateKeyList) {
                ModelItemDTO miDTO = dataModel.get(EngineUtil.mergeModelKey(element.toString(), key));
                if (miDTO == null) continue;
                switch (miDTO.getState()) {
                    case 12: {
                        state = 12;
                        break;
                    }
                    case 11: {
                        state = 11;
                        break;
                    }
                }
            }
        }
        return state;
    }

    @Override
    public WizardDisplayInfoDTO.HeaderItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, @NonNull String key) {
        int state = this.getState(dataModel, key);
        ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO> labelAddOnDTOs = new ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO>();
        if (this.headerAddOns != null) {
            for (LabelAddOn element : this.headerAddOns) {
                WizardDisplayInfoDTO.LabelAddOnDTO formInfo = element.getFormInfo(dataModel, key);
                if (formInfo == null) continue;
                labelAddOnDTOs.add(formInfo);
            }
        }
        if (labelAddOnDTOs.isEmpty()) {
            labelAddOnDTOs = null;
        }
        int corrColspan = this.colspan;
        if (state != 12) {
            Header element;
            int index = 0;
            for (int i = 0; i < ((Section)this.getParent()).getHeaders().size() && (element = ((Section)this.getParent()).getHeaders().get(i)).getState(dataModel, key) != 12; ++i) {
                if (element == this) {
                    index += i;
                    break;
                }
                if (element.colspan <= 1) continue;
                index += element.colspan - 1;
            }
            int colDefState = 11;
            block6: for (int i = 0; i < this.colspan; ++i) {
                ColDef coldef = ((Section)this.getParent()).getColdefs().get(index + i);
                WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = coldef.getFormInfo(dataModel, key);
                switch (cdiDTO.getState()) {
                    case 12: {
                        --corrColspan;
                        continue block6;
                    }
                    case 11: {
                        continue block6;
                    }
                    default: {
                        colDefState = 1;
                    }
                }
            }
            if (colDefState == 11) {
                state = colDefState;
            }
            if (corrColspan <= 0) {
                return null;
            }
        }
        if (state == 12) {
            return null;
        }
        return new WizardDisplayInfoDTO.HeaderItemDTO(this.getUniqueItemIdentifier(), state, this.name, corrColspan, labelAddOnDTOs);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<LabelAddOn> labelAddOns = new ArrayList<LabelAddOn>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add((LabelAddOn)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (labelAddOns.isEmpty() && element.getAttribute("header-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("header-add-on")));
            }
            if (labelAddOns.isEmpty()) {
                labelAddOns = null;
            }
            return new ClassObjectPair(Header.class, (Object)new Header(element.getAttributeValue("name"), element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1, element.getAttributeValue("state"), labelAddOns));
        }
    }
}

