/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.engine.wizarddisplay.SpannableItem;
import ch.dvbern.tax.common.engine.wizarddisplay.WItemValueHolder;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.presentation.common.util.Render;
import ch.dvbern.tax.common.presentation.common.util.RenderBuilder;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.ColorConstants;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Item
extends WizardDisplayModelItem
implements WItemValueHolder,
SpannableItem {
    private final int colspan;
    private final int rowspan;
    private final int type;
    private final String valueKey;
    private LogicModelItem valueModelItem;
    private final String stateKey;
    private Boolean readonly;
    private final String align;
    private final String style;
    private final String styleClass;
    private final Layout layout;
    private final String id;
    private final Boolean negative;
    private final AbstractConverter<?> rendererAndValidator;
    private final boolean cleanOnLoad;
    private final String messageItemKey;
    private final String fgColor;
    private final Render reRender;
    private final String hiddenLabel;
    private final String placeholder;
    private final @Nullable String titleKey;
    private final boolean emitFocusEvents;

    public Item(int type, String valueKey, int colspan, int rowspan, String stateKey, Boolean readonly, String align, String style, String styleClass, Layout layout, String id, Boolean negative, AbstractConverter<?> rendererAndValidator, boolean cleanOnLoad, String messageItemKey, String fgColor, Render reRender, String hiddenLabel, String placeholder, @Nullable String titleKey, boolean emitFocusEvents) {
        this.type = type;
        this.valueKey = valueKey;
        this.colspan = colspan;
        this.rowspan = rowspan;
        this.stateKey = stateKey;
        this.readonly = readonly;
        this.align = align;
        this.style = style;
        this.styleClass = styleClass;
        this.layout = layout;
        this.id = id;
        this.negative = negative;
        this.rendererAndValidator = rendererAndValidator;
        this.cleanOnLoad = cleanOnLoad;
        this.messageItemKey = messageItemKey;
        this.fgColor = fgColor;
        this.reRender = reRender;
        this.hiddenLabel = hiddenLabel;
        this.placeholder = placeholder;
        this.titleKey = titleKey;
        this.emitFocusEvents = emitFocusEvents;
    }

    public List<WizardDisplayModelItem> getChildren() {
        return null;
    }

    @Override
    public int getColspan() {
        return this.colspan;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public AbstractConverter<?> getRendererAndValidator() {
        return this.rendererAndValidator;
    }

    @Override
    public String getValueKey() {
        return this.valueKey;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    @Override
    protected DisplayItemUniqueID createUniqueId() {
        return new DisplayItemUniqueID(this.findContainingForm().getName(), this.findContainingForm().nextInputItemUniqueId());
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        LogicModelItem lmi = logicModelItems.get(this.valueKey);
        if (lmi == null) {
            throw new InvalidModelException("invalid value-reference in item: " + this.valueKey);
        }
        if (this.stateKey != null && logicModelItems.get(this.stateKey) == null) {
            throw new InvalidModelException("invalid state-reference in item: " + this.stateKey);
        }
        if (this.messageItemKey != null && logicModelItems.get(this.messageItemKey) == null) {
            throw new InvalidModelException("invalid messageItem-reference in item: " + this.messageItemKey);
        }
        if (this.readonly == null) {
            this.readonly = lmi.isReadonly();
        }
        this.valueModelItem = lmi;
    }

    @Override
    public WizardDisplayInfoDTO.ItemItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ModelItemDTO messageItemDTO;
        ModelItemDTO stateDTO;
        String dataModelKey = EngineUtil.mergeModelKey(this.valueKey, key);
        OptionItemsDTO optionItems = null;
        if (this.valueModelItem instanceof LogicModelItem.SelectItem) {
            optionItems = ((LogicModelItem.SelectItem)((Object)this.valueModelItem)).getOptionItems(dataModel, dataModelKey);
        }
        Row row = (Row)this.getParent();
        int index = row.getIndex(this);
        ModelItemDTO modelItemDTO = dataModel.getModelItem(DMK.parse(dataModelKey));
        Object value = this.cleanOnLoad ? null : modelItemDTO.getValue();
        Collection<MessageItemDTO> messages = modelItemDTO.getMessages();
        int state = 1;
        if (modelItemDTO != null) {
            state = modelItemDTO.getState();
        }
        if (this.stateKey != null && (stateDTO = dataModel.get(EngineUtil.mergeModelKey(this.stateKey, key))) != null) {
            switch (stateDTO.getState()) {
                case 11: 
                case 12: {
                    state = 11;
                    break;
                }
            }
        }
        if (this.messageItemKey != null && (messageItemDTO = dataModel.get(EngineUtil.mergeModelKey(this.messageItemKey, key))) != null) {
            if (messageItemDTO.getMessages() != null) {
                if (messages == null) {
                    messages = messageItemDTO.getMessages();
                } else {
                    messages.addAll(messageItemDTO.getMessages());
                }
            }
            if (ModelItemDTO.isMoreImportantState(messageItemDTO.getState(), state)) {
                state = messageItemDTO.getState();
            }
        }
        int width = 0;
        boolean isWidthUndefined = false;
        int corrColspan = this.colspan;
        int colDefState = 11;
        block7: for (int i = 0; i < this.colspan; ++i) {
            ColDef coldef = ((Section)row.getParent()).getColdefs().get(index + i);
            WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = coldef.getFormInfo(dataModel, key);
            if (12 != cdiDTO.getState()) {
                if (!cdiDTO.isWidthUndefined() && !isWidthUndefined) {
                    width += Integer.parseInt(cdiDTO.getWidth());
                } else {
                    width = 0;
                    isWidthUndefined = true;
                }
            }
            switch (cdiDTO.getState()) {
                case 12: {
                    --corrColspan;
                    continue block7;
                }
                case 11: {
                    continue block7;
                }
                default: {
                    colDefState = 1;
                }
            }
        }
        if (colDefState == 11) {
            state = 11;
        }
        if (corrColspan <= 0) {
            return null;
        }
        return new WizardDisplayInfoDTO.ItemItemDTO(this.getUniqueItemIdentifier(), state, this.type, dataModelKey, value, corrColspan, this.rowspan, width, optionItems, messages, this.readonly, this.align, this.style, this.styleClass, this.layout, this.id, this.negative, this.rendererAndValidator, true, this.valueKey, this.fgColor, this.reRender, this.hiddenLabel, this.placeholder, this.titleKey, this.emitFocusEvents);
    }

    public static enum Layout {
        HORIZONTAL,
        VERTICAL;

    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String value;
            List elements = element.getChildren();
            AbstractConverter rendererAndValidator = null;
            if (elements.size() > 1) {
                throw new ElementParserException("invalid child element in: " + String.valueOf(element));
            }
            if (elements.size() == 1) {
                Element subElement = (Element)elements.get(0);
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (!(ref instanceof AbstractConverter)) {
                        throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                    }
                    rendererAndValidator = (AbstractConverter)ref;
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            WizardDisplayUtil.TypeAndConverter typeAndConverter = WizardDisplayUtil.parseInputType(element, rendererAndValidator);
            Boolean readonly = null;
            if (element.getAttribute("readonly") != null) {
                readonly = Boolean.valueOf(element.getAttributeValue("readonly"));
            }
            Boolean negative = Boolean.valueOf(element.getAttributeValue("negative"));
            String fgColor = element.getAttributeValue("fgColor");
            if (fgColor != null && ColorConstants.getColors().get(fgColor) == null) {
                throw new ElementParserException("invalid color definition in element " + element.getName());
            }
            Layout layout = null;
            String layoutStr = element.getAttribute("layout");
            if (layoutStr != null) {
                if (typeAndConverter.type != 1) {
                    throw new ElementParserException("Layout attribute is currently only supported for radio-buttons");
                }
                try {
                    layout = Layout.valueOf(layoutStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new ElementParserException("Invalid value for attribute layout: " + layoutStr);
                }
            }
            Render reRender = new Render();
            if (element.getAttribute("reRender") != null) {
                reRender = RenderBuilder.create(element.getAttributeValue("reRender")).build();
            }
            if (element.getAttributeValue("javaScript") != null) {
                throw new ElementParserException("invalid argument 'javaScript' in item " + element.getAttributeValue("value"));
            }
            if (element.getAttributeValue("scriptFile") != null) {
                throw new ElementParserException("invalid argument 'scriptFile' in item " + element.getAttributeValue("value"));
            }
            int rowspan = 1;
            if (element.getAttribute("rowspan") != null) {
                rowspan = WizardDisplayUtil.rowSpanToPixel(Integer.parseInt(element.getAttributeValue("rowspan")));
            }
            if ((value = element.getAttributeValue("value")) == null) {
                throw new ElementParserException("Attribute \"value\" is mandatory on w-item.");
            }
            int colspan = element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1;
            return new ClassObjectPair(Item.class, (Object)new Item(typeAndConverter.type, value, colspan, rowspan, element.getAttributeValue("state"), readonly, typeAndConverter.alignment, element.getAttributeValue("style"), element.getAttributeValue("styleClass"), layout, element.getAttributeValue("id"), negative, typeAndConverter.converter, Boolean.valueOf(element.getAttributeValue("clean-on-load")), element.getAttributeValue("messageItem"), fgColor, reRender, element.getAttributeValue("hiddenLabel"), element.getAttributeValue("placeholder"), element.getAttributeValue("titleKey"), WizardDisplayUtil.getBoolean(element.getAttributeValue("emitFocusEvents"), false)));
        }
    }
}

