/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.SpannableItem;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.util.ColorConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Label
extends WizardDisplayModelItem
implements SpannableItem {
    private final int colspan;
    private final String name;
    private List<String> stateKeyList;
    private final String align;
    private final String style;
    private final String styleClass;
    private final List<LabelAddOn> labelAddOns;
    private final boolean autoFormatAddOns;
    private final String fgColor;
    private final String labelFor;
    private final @Nullable Help help;

    public Label(String name, int colspan, String stateKeys, String align, String style, String styleClass, List<LabelAddOn> labelAddOns, boolean autoFormatAddOns, String fgColor, String labelFor, @Nullable Help help) {
        this.name = name;
        this.colspan = colspan;
        this.help = help;
        if (stateKeys != null && !stateKeys.isEmpty()) {
            this.stateKeyList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(stateKeys, ",");
            while (st.hasMoreTokens()) {
                this.stateKeyList.add(st.nextToken().trim());
            }
        }
        this.align = align;
        this.style = style;
        this.styleClass = styleClass;
        this.labelAddOns = labelAddOns;
        this.autoFormatAddOns = autoFormatAddOns;
        this.fgColor = fgColor;
        this.labelFor = labelFor;
    }

    public List<WizardDisplayModelItem> getChildren() {
        if (this.help != null) {
            return Collections.singletonList(this.help);
        }
        return Collections.emptyList();
    }

    @Override
    public int getColspan() {
        return this.colspan;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.stateKeyList != null) {
            for (String key : this.stateKeyList) {
                if (logicModelItems.get(key) != null) continue;
                throw new InvalidModelException("invalid state-reference in label (key=" + key + ")");
            }
        }
        if (this.labelAddOns != null) {
            for (LabelAddOn element : this.labelAddOns) {
                element.additionalInitializeWizardDisplayModel(logicModelItems);
            }
        }
    }

    @Override
    public WizardDisplayInfoDTO.LabelItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO> labelAddOnDTOs = new ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO>();
        if (this.labelAddOns != null) {
            for (LabelAddOn element : this.labelAddOns) {
                WizardDisplayInfoDTO.LabelAddOnDTO formInfo = element.getFormInfo(dataModel, key);
                if (formInfo == null) continue;
                labelAddOnDTOs.add(formInfo);
            }
        }
        if (labelAddOnDTOs.isEmpty()) {
            labelAddOnDTOs = null;
        }
        WizardDisplayInfoDTO.HelpItemDTO helpDTO = null;
        if (this.help != null) {
            helpDTO = this.help.getFormInfo(dataModel, key);
        }
        if (this.getParent() instanceof Form) {
            int state = 1;
            if (this.stateKeyList != null) {
                for (String element : this.stateKeyList) {
                    ModelItemDTO miDTO = dataModel.get(EngineUtil.mergeModelKey(element, key));
                    if (miDTO == null) {
                        state = 12;
                        continue;
                    }
                    if (!miDTO.hasMoreImportantState(state)) continue;
                    state = miDTO.getState();
                }
            }
            return new WizardDisplayInfoDTO.LabelItemDTO(this.getUniqueItemIdentifier(), state, this.name, this.colspan, this.align, this.style, this.styleClass, labelAddOnDTOs, this.autoFormatAddOns, this.fgColor, this.labelFor, helpDTO);
        }
        Row row = (Row)this.getParent();
        int index = row.getIndex(this);
        int state = 1;
        if (this.stateKeyList != null) {
            for (String element : this.stateKeyList) {
                ModelItemDTO miDTO = dataModel.get(EngineUtil.mergeModelKey(element, key));
                if (miDTO == null) continue;
                switch (miDTO.getState()) {
                    case 11: 
                    case 12: {
                        state = 11;
                        break;
                    }
                }
            }
        }
        int width = 0;
        boolean isWidthUndefined = false;
        int corrColspan = this.colspan;
        int colDefState = 11;
        block10: for (int i = 0; i < this.colspan; ++i) {
            int colDefIndex = index + i;
            List<ColDef> colDefs = ((Section)this.getParent().getParent()).getColdefs();
            if (colDefIndex >= colDefs.size()) {
                throw new IllegalArgumentException("colDefIndex(" + index + "+" + i + "=" + colDefIndex + ") > number of coldefs(" + colDefs.size() + ") for label with name: " + this.name);
            }
            ColDef coldef = colDefs.get(colDefIndex);
            WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = coldef.getFormInfo(dataModel, key);
            if (12 != cdiDTO.getState()) {
                if (!cdiDTO.isWidthUndefined() && !isWidthUndefined) {
                    width += Integer.parseInt(cdiDTO.getWidth());
                } else {
                    width = 0;
                    isWidthUndefined = true;
                }
            }
            switch (cdiDTO.getState()) {
                case 12: {
                    --corrColspan;
                    continue block10;
                }
                case 11: {
                    continue block10;
                }
                default: {
                    colDefState = 1;
                }
            }
        }
        if (colDefState == 11) {
            state = 11;
        }
        if (corrColspan <= 0) {
            return null;
        }
        return new WizardDisplayInfoDTO.LabelItemDTO(this.getUniqueItemIdentifier(), state, this.name, corrColspan, width, this.align, this.style, this.styleClass, labelAddOnDTOs, this.autoFormatAddOns, this.fgColor, this.labelFor, helpDTO);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String fgColor;
            List elements = element.getChildren();
            ArrayList<LabelAddOn> labelAddOns = new ArrayList<LabelAddOn>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add((LabelAddOn)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (labelAddOns.isEmpty() && element.getAttribute("label-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("label-add-on")));
            }
            if (labelAddOns.isEmpty()) {
                labelAddOns = null;
            }
            boolean autoFormatAddOns = WizardDisplayUtil.getBoolean(element.getAttribute("autoFormatAddOns"), true);
            String align = null;
            if (element.getAttribute("align") != null) {
                align = element.getAttributeValue("align");
            }
            if ((fgColor = element.getAttributeValue("fgColor")) != null && ColorConstants.getColors().get(fgColor) == null) {
                throw new ElementParserException("invalid color definition in element " + element.getName());
            }
            int colspan = element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1;
            Help help = null;
            String helpKey = element.getAttribute("help");
            if (helpKey != null) {
                help = new Help(helpKey);
            }
            return new ClassObjectPair(Label.class, (Object)new Label(element.getAttributeValue("name"), colspan, element.getAttributeValue("state"), align, element.getAttributeValue("style"), element.getAttributeValue("styleClass"), labelAddOns, autoFormatAddOns, fgColor, element.getAttributeValue("for"), help));
        }
    }
}

