/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.SpannableItem;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Button;
import ch.dvbern.tax.common.engine.wizarddisplay.items.FileDetails;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Label;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Link;
import ch.dvbern.tax.common.engine.wizarddisplay.items.RowItemBase;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.engine.wizarddisplay.items.StateIndicator;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Table;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Row
extends RowItemBase {
    private final Help help;
    private final List<WizardDisplayModelItem> cols;
    private List<String> stateKeyList;
    private List<String> invisibleIfTrueList;
    private List<String> invisibleIfFalseList;
    private final String viewId;

    public Row(Help help, List<WizardDisplayModelItem> cols, String stateKeys, String invisibleIfTrueKey, String invisibleIfFalseKey, String viewId) {
        this.help = help;
        this.cols = cols;
        if (stateKeys != null && !stateKeys.isEmpty()) {
            this.stateKeyList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(stateKeys, ",");
            while (st.hasMoreTokens()) {
                this.stateKeyList.add(st.nextToken().trim());
            }
        }
        if (invisibleIfTrueKey != null) {
            this.invisibleIfTrueList = new ArrayList<String>();
            StringTokenizer invisibleIfTrueTokenizer = new StringTokenizer(invisibleIfTrueKey, ",");
            while (invisibleIfTrueTokenizer.hasMoreTokens()) {
                this.invisibleIfTrueList.add(invisibleIfTrueTokenizer.nextToken().trim());
            }
        }
        if (invisibleIfFalseKey != null) {
            this.invisibleIfFalseList = new ArrayList<String>();
            StringTokenizer invisibleIfFalseTokenizer = new StringTokenizer(invisibleIfFalseKey, ",");
            while (invisibleIfFalseTokenizer.hasMoreTokens()) {
                this.invisibleIfFalseList.add(invisibleIfFalseTokenizer.nextToken().trim());
            }
        }
        this.viewId = viewId;
    }

    public int getIndex(WizardDisplayModelItem thisItem) {
        int index = 0;
        for (WizardDisplayModelItem item : this.getCols()) {
            SpannableItem spannable;
            if (item.equals(thisItem)) break;
            int colspan = 1;
            if (item instanceof SpannableItem && (spannable = (SpannableItem)((Object)item)).getColspan() > 1) {
                colspan = spannable.getColspan();
            }
            index += colspan;
        }
        return index;
    }

    public List<WizardDisplayModelItem> getCols() {
        return this.cols;
    }

    public List<WizardDisplayModelItem> getChildren() {
        ArrayList<WizardDisplayModelItem> result = new ArrayList<WizardDisplayModelItem>();
        if (this.help != null) {
            result.add(this.help);
        }
        if (this.cols != null) {
            result.addAll(this.cols);
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.stateKeyList != null) {
            for (String key : this.stateKeyList) {
                if (logicModelItems.get(key) != null) continue;
                throw new InvalidModelException("invalid state-reference in Row (key=" + key + ")");
            }
        }
        if (this.invisibleIfTrueList != null) {
            for (String key : this.invisibleIfTrueList) {
                if (logicModelItems.get(key) != null) continue;
                throw new InvalidModelException("invalid invisibleIfTrueKey-reference in Row (key=" + key + ")");
            }
        }
        if (this.invisibleIfFalseList != null) {
            for (String key : this.invisibleIfFalseList) {
                if (logicModelItems.get(key) != null) continue;
                throw new InvalidModelException("invalid invisibleIfFalseKey-reference in Row (key=" + key + ")");
            }
        }
    }

    @Override
    public WizardDisplayInfoDTO.RowItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ModelItemDTO miDTO;
        WizardDisplayInfoDTO.HelpItemDTO formInfo;
        if (this.getChildren() == null) {
            return new WizardDisplayInfoDTO.RowItemDTO(this.getUniqueItemIdentifier(), 1, null, null, null, false, this.viewId, this.stateKeyList);
        }
        boolean[] coldefs = new boolean[((Section)this.getParent()).getColdefs().size()];
        for (int i = 0; i < ((Section)this.getParent()).getColdefs().size(); ++i) {
            coldefs[i] = true;
        }
        WizardDisplayInfoDTO.HelpItemDTO helpDTO = null;
        if (this.help != null && (formInfo = this.help.getFormInfo(dataModel, key)) != null) {
            helpDTO = formInfo;
        }
        int state = 1;
        if (this.stateKeyList != null) {
            for (String string : this.stateKeyList) {
                miDTO = dataModel.get(EngineUtil.mergeModelKey(string, key));
                if (miDTO == null) {
                    state = 12;
                    continue;
                }
                if (!miDTO.hasMoreImportantState(state)) continue;
                state = miDTO.getState();
            }
        }
        if (this.invisibleIfTrueList != null && !this.invisibleIfTrueList.isEmpty()) {
            for (String invisibleIfTrueKey : this.invisibleIfTrueList) {
                miDTO = dataModel.get(EngineUtil.mergeModelKey(invisibleIfTrueKey, key));
                if (miDTO == null || miDTO.getValue() == null) {
                    state = 12;
                    continue;
                }
                if (miDTO.getValue() instanceof Number && ((Number)miDTO.getValue()).intValue() != 0) {
                    state = 12;
                }
                if (!(miDTO.getValue() instanceof Boolean) || !((Boolean)miDTO.getValue()).booleanValue()) continue;
                state = 12;
            }
        }
        if (this.invisibleIfFalseList != null && !this.invisibleIfFalseList.isEmpty()) {
            for (String invisibleIfFalseKey : this.invisibleIfFalseList) {
                miDTO = dataModel.get(EngineUtil.mergeModelKey(invisibleIfFalseKey, key));
                if (miDTO == null || miDTO.getValue() == null) {
                    state = 12;
                    continue;
                }
                if (miDTO.getValue() instanceof Number && ((Number)miDTO.getValue()).intValue() == 0) {
                    state = 12;
                }
                if (!(miDTO.getValue() instanceof Boolean) || ((Boolean)miDTO.getValue()).booleanValue()) continue;
                state = 12;
            }
        }
        ArrayList<WizardDisplayInfoDTO.AbstractItemDTO> colsDTO = new ArrayList<WizardDisplayInfoDTO.AbstractItemDTO>();
        if (this.cols.size() > coldefs.length) {
            throw new IllegalArgumentException("Must have at least " + this.cols.size() + " col-defs, but found only " + coldefs.length + " in form " + key);
        }
        for (int i = 0; i < this.cols.size(); ++i) {
            WizardDisplayModelItem element;
            Object formInfo2;
            if (i >= coldefs.length || !coldefs[i] || (formInfo2 = (element = this.cols.get(i)).getFormInfo(dataModel, key)) == null) continue;
            if (!(formInfo2 instanceof WizardDisplayInfoDTO.AbstractItemDTO)) {
                throw new ApplicationException("formInfo is not an AbstractItemDTO: " + formInfo2.getClass().getName());
            }
            colsDTO.add((WizardDisplayInfoDTO.AbstractItemDTO)formInfo2);
            ModelItemDTO miDTO2 = null;
            if (element instanceof Item) {
                Item item = (Item)element;
                miDTO2 = dataModel.get(EngineUtil.mergeModelKey(item.getValueKey(), key));
            }
            if (element instanceof FileDetails) {
                FileDetails fileDetails = (FileDetails)element;
                miDTO2 = dataModel.get(EngineUtil.mergeModelKey(fileDetails.getValueLmk().toExternalForm(), key));
            }
            if (miDTO2 == null || !ModelItemDTO.isPropagatableState(miDTO2.getState()) || !miDTO2.hasMoreImportantState(state)) continue;
            state = miDTO2.getState();
        }
        return new WizardDisplayInfoDTO.RowItemDTO(this.getUniqueItemIdentifier(), state, key, colsDTO, helpDTO, false, this.viewId, this.stateKeyList);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<WizardDisplayModelItem> childItems = elements.isEmpty() ? null : new ArrayList<WizardDisplayModelItem>();
            Help help = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Help) {
                        help = (Help)ref;
                        continue;
                    }
                    if (ref instanceof Label || ref instanceof Item || ref instanceof Button || ref instanceof Link || ref instanceof FileDetails || ref instanceof StateIndicator || ref instanceof Table) {
                        childItems.add((WizardDisplayModelItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (element.getAttribute("help") != null) {
                help = new Help(element.getAttributeValue("help"));
            }
            return new ClassObjectPair(Row.class, (Object)new Row(help, childItems, element.getAttributeValue("state"), element.getAttributeValue("invisible-if-true"), element.getAttributeValue("invisible-if-false"), element.getAttributeValue("viewId")));
        }
    }
}

