/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.BooleanConverter;
import ch.dvbern.tax.common.transfer.dto.convert.ComboboxConverter;
import ch.dvbern.tax.common.transfer.dto.convert.CurrencyConverter;
import ch.dvbern.tax.common.transfer.dto.convert.DateConverter;
import ch.dvbern.tax.common.transfer.dto.convert.DayMonthConverter;
import ch.dvbern.tax.common.transfer.dto.convert.FirstLetterConverter;
import ch.dvbern.tax.common.transfer.dto.convert.Float1Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float2Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float3Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float4Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float5Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float6Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float7Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float8Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float9Converter;
import ch.dvbern.tax.common.transfer.dto.convert.IntConverter;
import ch.dvbern.tax.common.transfer.dto.convert.IntSimpleConverter;
import ch.dvbern.tax.common.transfer.dto.convert.MonthYearConverter;
import ch.dvbern.tax.common.transfer.dto.convert.NumberConverter;
import ch.dvbern.tax.common.transfer.dto.convert.PrintZeroConverter;
import ch.dvbern.tax.common.transfer.dto.convert.RadioConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextareaConverter;

public final class WizardDisplayUtil {
    public static final String ALIGNMENT_LEFT = "left";
    public static final String ALIGNMENT_CENTER = "center";
    public static final String ALIGNMENT_RIGHT = "right";

    private WizardDisplayUtil() {
    }

    public static TypeAndConverter parseInputType(Element element, AbstractConverter<?> converter) throws ElementParserException {
        String printZero;
        String inputType = element.getAttributeValue("type");
        if (inputType != null) {
            inputType = inputType.toLowerCase();
        }
        TypeAndConverter result = new TypeAndConverter();
        if (inputType == null || inputType.isEmpty()) {
            result.type = 0;
            result.converter = converter != null ? converter : new TextConverter(WizardDisplayUtil.getTextMaxLength(element, 100));
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("text")) {
            result.type = 0;
            result.converter = converter != null ? converter : new TextConverter(WizardDisplayUtil.getTextMaxLength(element, 100));
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("textarea")) {
            result.type = 4;
            result.converter = converter != null ? converter : new TextareaConverter(WizardDisplayUtil.getTextMaxLength(element, 3680));
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("int")) {
            result.type = 0;
            boolean printZeroIfReadonly = Boolean.valueOf(element.getAttributeValue("printZeroIfReadonly"));
            result.converter = converter != null ? converter : new IntConverter(WizardDisplayUtil.getTextMaxLength(element, 11), printZeroIfReadonly);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("float-1")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float1Converter(WizardDisplayUtil.getTextMaxLength(element, 14), dynamicFP);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("float-2")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float2Converter(WizardDisplayUtil.getTextMaxLength(element, 14), dynamicFP);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("float-3")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float3Converter(WizardDisplayUtil.getTextMaxLength(element, 15), dynamicFP);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("float-4")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float4Converter(WizardDisplayUtil.getTextMaxLength(element, 16), dynamicFP);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("float-5")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float5Converter(WizardDisplayUtil.getTextMaxLength(element, 17), dynamicFP);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("float-6")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float6Converter(WizardDisplayUtil.getTextMaxLength(element, 18), dynamicFP);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("float-7")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float7Converter(WizardDisplayUtil.getTextMaxLength(element, 19), dynamicFP);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("float-8")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float8Converter(WizardDisplayUtil.getTextMaxLength(element, 20), dynamicFP);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("float-9")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float9Converter(WizardDisplayUtil.getTextMaxLength(element, 21), dynamicFP);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("currency")) {
            result.type = 0;
            result.converter = converter != null ? converter : new CurrencyConverter(14);
            result.alignment = ALIGNMENT_RIGHT;
        } else if (inputType.equals("date")) {
            result.type = 0;
            result.converter = converter != null ? converter : new DateConverter();
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("boolean")) {
            result.type = 3;
            result.converter = converter != null ? converter : new BooleanConverter();
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("radio")) {
            result.type = 1;
            result.converter = converter != null ? converter : new RadioConverter();
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("combobox")) {
            result.type = 2;
            result.converter = converter != null ? converter : new ComboboxConverter(false);
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("combobox-short")) {
            result.type = 2;
            result.converter = converter != null ? converter : new ComboboxConverter(true);
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("int-simple")) {
            result.type = 0;
            result.converter = converter != null ? converter : new IntSimpleConverter(WizardDisplayUtil.getTextMaxLength(element, 11));
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("day-month")) {
            result.type = 0;
            result.converter = converter != null ? converter : new DayMonthConverter(element.getAttributeValue("year"), element.getAttributeValue("year-abs-ref"));
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("month-year")) {
            result.type = 0;
            result.converter = converter != null ? converter : new MonthYearConverter();
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("first-letter")) {
            result.type = 0;
            String s = element.getAttributeValue("chars");
            int chars = 1;
            if (s != null && !s.isEmpty()) {
                chars = Integer.parseInt(s);
            }
            result.converter = converter != null ? converter : new FirstLetterConverter(chars);
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("hidden")) {
            result.type = 100;
            result.converter = converter != null ? converter : new TextConverter(WizardDisplayUtil.getTextMaxLength(element, 100));
            result.alignment = ALIGNMENT_LEFT;
        } else if (inputType.equals("suggestions")) {
            result.type = 5;
            result.converter = converter != null ? converter : new TextConverter(WizardDisplayUtil.getTextMaxLength(element, 100));
            result.alignment = ALIGNMENT_LEFT;
        } else {
            throw new RuntimeException("invalid inputType: '" + inputType + "'");
        }
        if (element.getAttributeValue("align") != null) {
            result.alignment = element.getAttributeValue("align");
        }
        if ((printZero = element.getAttributeValue("printZero")) != null) {
            boolean flag;
            if (!(result.converter instanceof NumberConverter)) {
                throw new ElementParserException("Attribute 'printZero' may only be used with instances of NumberConverter.");
            }
            if (printZero.equalsIgnoreCase("true")) {
                flag = true;
            } else if (printZero.equalsIgnoreCase("false")) {
                flag = false;
            } else {
                throw new ElementParserException("Attribute 'printZero' must be either true or false.");
            }
            NumberConverter numberConverter = (NumberConverter)result.converter;
            PrintZeroConverter printZeroConverter = new PrintZeroConverter(numberConverter, flag);
            result.converter = printZeroConverter;
        }
        return result;
    }

    private static int getTextMaxLength(Element element, int defaultMaxLength) {
        if (element.getAttribute("maxlength") != null) {
            defaultMaxLength = Integer.parseInt(element.getAttributeValue("maxlength"));
        }
        return defaultMaxLength;
    }

    public static boolean getBoolean(String s, boolean defaultValue) {
        return ExpertDisplayUtil.getBoolean(s, defaultValue);
    }

    public static String getString(String s, String defaultValue) {
        return ExpertDisplayUtil.getString(s, defaultValue);
    }

    public static int getInt(String s, int defaultValue) {
        return ExpertDisplayUtil.getInt(s, defaultValue);
    }

    public static int rowSpanToPixel(int rowspan) {
        return rowspan * 10;
    }

    public static class TypeAndConverter {
        public int type;
        public String alignment;
        public AbstractConverter<?> converter;
    }
}

