/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.conf;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfigProvider.class);

    public static ApplicationConfig getConfiguration() {
        ApplicationConfig config = null;
        try {
            for (ApplicationConfigProvider provider : ServiceLoader.load(ApplicationConfigProvider.class)) {
                config = provider.load();
                LOG.debug("Querying application config provider {}: {}", (Object)provider, (Object)config);
                if (config == null) continue;
                break;
            }
        }
        catch (ServiceConfigurationError e) {
            throw new IllegalStateException("configuration error: cannot retrieve application configuration  provider instance.", e);
        }
        return config;
    }

    protected abstract ApplicationConfig load();
}

