/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.util;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MailHelper.class);
    private static final String MAIL_TRANSPORT_PROTOCOL_PROPERTY_KEY = "mail.transport.protocol";
    private static final String MAIL_SMTP_HOST_PROPERTY_KEY = "mail.smtp.host";
    private static final String MAIL_SMTP_PORT_PROPERTY_KEY = "mail.smtp.port";
    private static final String MAIL_SMTP_USER_PROPERTY_KEY = "mail.smtp.user";
    private static final String MAIL_SMTP_PASSWORD_PROPERTY_KEY = "mail.smtp.password";
    private static final String MAIL_SENDER_NAME_PROPERTY_KEY = "mail.confirmation.sender.name";
    private static final String MAIL_SENDER_ADDRESS_PROPERTY_KEY = "mail.confirmation.sender.address";
    private static final String ERROR_SENDING_MAIL = "Error sending mail";
    private static final String ERROR_CREATING_MAIL = "Could not create mail";
    private final String protocol;
    private final String host;
    private final String port;
    private String user = null;
    private String password = null;
    private String senderName = null;
    private String senderAddress = null;

    public MailHelper() {
        ApplicationConfig config = ApplicationConfig.getInstance();
        this.protocol = config.getMailTransportProtocol();
        this.host = config.getMailSmtpHost();
        this.port = config.getMailSmtpPort();
        this.user = config.getMailSmtpUser();
        this.password = config.getMailSmtpPassword();
        this.senderName = config.getMailSenderName();
        this.senderAddress = config.getMailSenderAdress();
    }

    public MailHelper(String protocol, String host, String port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public MailHelper(String protocol, String host, String port, String user, String password) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    @Deprecated(forRemoval=true)
    public int sendMail(String from, String to, String subject, String content) {
        return this.sendMail(from, to, null, null, subject, content);
    }

    public int sendMail(InternetAddress from, InternetAddress[] to, String subject, String content) {
        return this.sendMail(from, to, null, null, subject, content);
    }

    @Deprecated(forRemoval=true)
    public int sendMail(String from, String to, @Nullable String cc, @Nullable String bcc, String subject, String content) {
        try {
            return this.sendMail(new InternetAddress(from), InternetAddress.parse((String)to, (boolean)false), cc != null ? InternetAddress.parse((String)cc, (boolean)false) : null, bcc != null ? InternetAddress.parse((String)bcc, (boolean)false) : null, subject, content);
        }
        catch (AddressException e) {
            LOG.warn("mail recipients could not be set", (Throwable)e);
            return Status.FAILURE.getCode();
        }
    }

    public int sendMail(InternetAddress from, InternetAddress[] to, InternetAddress @Nullable [] cc, InternetAddress @Nullable [] bcc, String subject, String textContent, DataSource attachmentDataSource, String attachmentFileName) {
        MimeBodyPart textPart = new MimeBodyPart();
        MimeBodyPart attachmentPart = new MimeBodyPart();
        MimeMultipart multipart = new MimeMultipart();
        try {
            textPart.setText(textContent);
            attachmentPart.setDataHandler(new DataHandler(attachmentDataSource));
            attachmentPart.setFileName(attachmentFileName);
            multipart.addBodyPart((BodyPart)textPart);
            multipart.addBodyPart((BodyPart)attachmentPart);
        }
        catch (MessagingException e) {
            LOG.warn(ERROR_SENDING_MAIL, (Throwable)e);
            return Status.FAILURE.getCode();
        }
        return this.sendMail(from, to, cc, bcc, subject, (Multipart)multipart);
    }

    public int sendMail(InternetAddress from, InternetAddress[] to, InternetAddress @Nullable [] cc, InternetAddress @Nullable [] bcc, String subject, Multipart multipart) {
        try {
            MimeMessage msg = this.createProtoMessage(from, to, cc, bcc, subject);
            if (msg == null) {
                LOG.warn(ERROR_CREATING_MAIL);
                return Status.FAILURE.getCode();
            }
            msg.setContent(multipart);
            Transport.send((Message)msg);
            return Status.OK.getCode();
        }
        catch (SendFailedException sfe) {
            String invalidAdressesStr = Arrays.toString(sfe.getInvalidAddresses());
            LOG.warn("Invalid receiver address specified '{}'", (Object)invalidAdressesStr, (Object)sfe);
            return Status.FAILURE.getCode();
        }
        catch (MessagingException ex) {
            LOG.warn(ERROR_SENDING_MAIL, (Throwable)ex);
            return Status.FAILURE.getCode();
        }
    }

    public int sendMail(InternetAddress from, InternetAddress[] to, InternetAddress @Nullable [] cc, InternetAddress @Nullable [] bcc, String subject, String content) {
        try {
            MimeMessage msg = this.createProtoMessage(from, to, cc, bcc, subject);
            if (msg == null) {
                LOG.warn(ERROR_CREATING_MAIL);
                return Status.FAILURE.getCode();
            }
            msg.setContent((Object)content, "text/plain;charset=iso-8859-1");
            Transport.send((Message)msg);
            return Status.OK.getCode();
        }
        catch (SendFailedException sfe) {
            String invalidAdressesAsString = Arrays.toString(sfe.getInvalidAddresses());
            LOG.warn("Invalid receiver address specified '{}'", (Object)invalidAdressesAsString, (Object)sfe);
            return Status.FAILURE.getCode();
        }
        catch (MessagingException ex) {
            LOG.warn(ERROR_SENDING_MAIL, (Throwable)ex);
            return Status.FAILURE.getCode();
        }
    }

    private @Nullable MimeMessage createProtoMessage(InternetAddress from, InternetAddress[] to, InternetAddress @Nullable [] cc, InternetAddress @Nullable [] bcc, String subject) throws MessagingException {
        Session session = this.createSession();
        if (session == null) {
            return null;
        }
        MimeMessage msg = new MimeMessage(session);
        if (from != null) {
            msg.setFrom((Address)from);
        } else {
            msg.setFrom();
        }
        msg.addRecipients(Message.RecipientType.TO, (Address[])to);
        if (cc != null) {
            msg.addRecipients(Message.RecipientType.CC, (Address[])cc);
        }
        if (bcc != null) {
            msg.addRecipients(Message.RecipientType.BCC, (Address[])bcc);
        }
        msg.setSubject(MailHelper.encodeMailString(subject));
        msg.setSentDate(new Date());
        return msg;
    }

    private @Nullable Session createSession() {
        Properties props = new Properties();
        if (this.protocol != null) {
            props.setProperty(MAIL_TRANSPORT_PROTOCOL_PROPERTY_KEY, this.protocol);
        }
        if (this.host == null) {
            LOG.warn("Unable to send mail, because mail host not specified.");
            return null;
        }
        props.setProperty(MAIL_SMTP_HOST_PROPERTY_KEY, this.host);
        if (this.port != null) {
            props.setProperty(MAIL_SMTP_PORT_PROPERTY_KEY, this.port);
        }
        if (this.user != null) {
            props.setProperty(MAIL_SMTP_USER_PROPERTY_KEY, this.user);
        }
        if (this.password != null) {
            props.setProperty(MAIL_SMTP_PASSWORD_PROPERTY_KEY, this.password);
        }
        if (this.senderAddress != null) {
            props.setProperty(MAIL_SENDER_ADDRESS_PROPERTY_KEY, this.senderAddress);
        }
        if (this.senderName != null) {
            props.setProperty(MAIL_SENDER_NAME_PROPERTY_KEY, this.senderName);
        }
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(false);
        return session;
    }

    private static @Nullable String encodeMailString(String text) {
        if (text != null) {
            try {
                text = MimeUtility.encodeText((String)text, (String)"iso-8859-1", null);
            }
            catch (UnsupportedEncodingException uex) {
                LOG.warn("could not encode mail string", (Throwable)uex);
            }
        }
        return text;
    }

    public static enum Status {
        OK(1),
        FAILURE(2);

        private final int code;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getCode() {
            return this.code;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Status(int code) {
            this.code = code;
        }
    }
}

