/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.imports;

import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.Importer;
import java.io.Serializable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportConfig
implements Serializable {
    private static final long serialVersionUID = -2329422972168180899L;
    private static final Logger LOG = LoggerFactory.getLogger(ImportConfig.class);
    private final Class<? extends Importer> mainImporter;
    private final Properties importSettings;

    public ImportConfig(Properties config, Properties importSettings) {
        this.importSettings = importSettings;
        try {
            String clazzName = config.getProperty("mainImporter");
            if (clazzName == null) {
                LOG.error("mainImporter is not set in the import configuration");
                this.mainImporter = FailImporter.class;
            } else {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(clazzName);
                if (!Importer.class.isAssignableFrom(clazz)) {
                    throw new RuntimeException("mainImporter is not a subclass of AbstractImporter");
                }
                this.mainImporter = clazz.asSubclass(Importer.class);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("mainImporter is not a valid class", e);
        }
    }

    public Class<? extends Importer> getMainImporter() {
        return this.mainImporter;
    }

    public Properties getImportSettings() {
        return this.importSettings;
    }

    private static class FailImporter
    implements Importer {
        public FailImporter() {
            throw new RuntimeException("Internal error: using FailImporter");
        }

        @Override
        public void doImport(String password) throws ImportException {
            throw new RuntimeException("Internal error: using FailImporter");
        }
    }
}

