/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print;

import ch.dvbern.lib.pdfforms.Page;
import ch.dvbern.lib.pdfforms.PdfFormFiller;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.FormRenderer;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.FormRendererFactory;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.common.presentation.common.print.ProgressListener;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.DokumentId;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.DvbTaxPdfFormPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfForm;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfFormException;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfPrinterInput;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.printing.PrintEntry;
import ch.dvbern.tax.common.transfer.dto.DisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrintUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PrintUtil.class);
    public static final String PDF_PREFIX = "tax_";
    public static final String PDF_SUFFIX = ".pdf";
    public static final String WIZARD_PRINT_BACKGROUND_FORM_KEY = "wizardprintbackground";
    private static final DokumentId[] EMPTY_DOKUMENTIDS = new DokumentId[0];

    private PrintUtil() {
    }

    public static @NonNull List<FormKey> getPrintAllKeys(@NonNull DvbTaxSession session) {
        if (session == null) {
            throw new NullPointerException("User session cannot be null.");
        }
        ArrayList<FormKey> allKeys = new ArrayList<FormKey>();
        for (ExpertDisplayInfoDTO.NavigationDTO navigationDTO : session.getExpertNavigationItems()) {
            if (navigationDTO.getState() != 1 && navigationDTO.getState() != 2 || navigationDTO.getPrintState() == 12 || !navigationDTO.isPrintGesamtausdruck()) continue;
            PrintUtil.addSubItems(navigationDTO, allKeys);
        }
        return allKeys;
    }

    private static void addSubItems(ExpertDisplayInfoDTO.NavigationDTO navigationDTO, List<FormKey> items) {
        assert (navigationDTO != null && items != null);
        if (navigationDTO.getSubItems() != null) {
            for (ExpertDisplayInfoDTO.NavigationDTO item : navigationDTO.getSubItems()) {
                if (item.getPrintState() == 12) continue;
                PrintUtil.addSubItems(item, items);
            }
        } else {
            FormKey key = new FormKey(navigationDTO.getAccessKey(), Mode.EXPERT);
            items.add(key);
        }
    }

    public static List<? extends DisplayInfoDTO> prepareForms(DvbTaxSession session, List<FormKey> formKeys, Locale locale, FormRendererConfiguration configuration) {
        if (session == null) {
            throw new NullPointerException("Session cannot be null.");
        }
        if (formKeys == null) {
            throw new NullPointerException("Forms cannot be null.");
        }
        if (configuration == null) {
            throw new NullPointerException("Form rendering configuration cannot be null.");
        }
        boolean wizardForms = false;
        ArrayList<DisplayInfoDTO> displayForms = new ArrayList<DisplayInfoDTO>(formKeys.size());
        for (FormKey formKey : formKeys) {
            if (formKey.getType() == Mode.EXPERT) {
                ExpertDisplayInfoDTO expertDisplayInfo = session.getExpertDisplayInfo(formKey.getKey(), locale, 2);
                displayForms.add(expertDisplayInfo);
                continue;
            }
            assert (formKey.getType() == Mode.WIZARD);
            wizardForms = true;
            WizardDisplayInfoDTO wizardDisplayInfo = session.getWizardDisplayInfo(formKey.getKey());
            displayForms.add(wizardDisplayInfo);
        }
        if (wizardForms) {
            ExpertDisplayInfoDTO wizardBackground = session.getExpertDisplayInfo(WIZARD_PRINT_BACKGROUND_FORM_KEY, locale, 2);
            configuration.withWizardBackground(wizardBackground);
        }
        return displayForms;
    }

    public static void print(@NonNull DvbTaxSession session, @NonNull PrintRequest request, @NonNull OutputStream out, boolean printSyncronized) throws FormRendererException, InterruptedException {
        Calendar beforePrint = Calendar.getInstance();
        if (printSyncronized) {
            PrintUtil.printsyncronized(session, request, out);
            Calendar afterPrint = Calendar.getInstance();
            LOG.info("SyncronizedPrint in:" + (afterPrint.getTimeInMillis() - beforePrint.getTimeInMillis()) + " ms");
        } else {
            PrintUtil.print(session, request, out);
            Calendar afterPrint = Calendar.getInstance();
            LOG.info("StandardPrint in:" + (afterPrint.getTimeInMillis() - beforePrint.getTimeInMillis()) + " ms");
        }
    }

    private static void print(@NonNull DvbTaxSession session, @NonNull PrintRequest request, @NonNull OutputStream out) throws FormRendererException, InterruptedException {
        Objects.requireNonNull(session, "User session cannot be null.");
        Objects.requireNonNull(request, "Print request cannot be null.");
        Objects.requireNonNull(out, "Output stream cannot be null.");
        FormRendererConfiguration configuration = request.getConfiguration();
        List<? extends DisplayInfoDTO> displayForms = PrintUtil.prepareForms(session, request.getFormKeys(), request.getConverterContext().getLocalizationHelper().getCurrentLocale(), configuration);
        FormRenderer r = FormRendererFactory.createRenderEngine(configuration, 0, request.getConverterContext(), request.getImageSource());
        ProgressListener progressListener = request.getProgressListener();
        if (progressListener != null) {
            r.addProgressListener(progressListener);
        }
        r.render(displayForms, out);
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new FormRendererException("Error flushing output", e);
        }
    }

    private static synchronized void printsyncronized(@NonNull DvbTaxSession session, @NonNull PrintRequest request, @NonNull OutputStream out) throws FormRendererException, InterruptedException {
        Objects.requireNonNull(session, "User session cannot be null.");
        Objects.requireNonNull(request, "Print request cannot be null.");
        Objects.requireNonNull(out, "Output stream cannot be null.");
        FormRendererConfiguration configuration = request.getConfiguration();
        List<? extends DisplayInfoDTO> displayForms = PrintUtil.prepareForms(session, request.getFormKeys(), request.getConverterContext().getLocalizationHelper().getCurrentLocale(), configuration);
        FormRenderer r = FormRendererFactory.createRenderEngine(configuration, 0, request.getConverterContext(), request.getImageSource());
        ProgressListener progressListener = request.getProgressListener();
        if (progressListener != null) {
            r.addProgressListener(progressListener);
        }
        r.render(displayForms, out);
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new FormRendererException("Error flushing output", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File mergeIntoTempFile(@Nullable PdfReader pdfFormReader, @Nullable PdfReader engineFormReader) throws IOException, FileNotFoundException {
        File mergedFile = File.createTempFile(PDF_PREFIX, PDF_SUFFIX);
        try (Document copyDoc = new Document();){
            PdfCopy copy = new PdfCopy(copyDoc, (OutputStream)new FileOutputStream(mergedFile));
            copyDoc.open();
            if (pdfFormReader != null) {
                PrintUtil.append(pdfFormReader, copy);
            }
            if (engineFormReader != null) {
                PrintUtil.append(engineFormReader, copy);
            }
        }
        return mergedFile;
    }

    private static void append(@NonNull PdfReader reader, @NonNull PdfCopy copy) throws IOException {
        int pages = reader.getNumberOfPages();
        for (int page = 1; page <= pages; ++page) {
            copy.addPage(copy.getImportedPage(reader, page));
        }
        copy.freeReader(reader);
        reader.close();
    }

    public static @NonNull File printMixed(DvbTaxSession session, PdfPrinterInput input, List<PrintEntry> printEntries, ImageSource imageSource, LocalizationHelper localizationHelper, FormRendererConfiguration rendererConfiguration, File targetDirectory) throws PdfFormException, IOException, MalformedURLException, InterruptedException, FileNotFoundException {
        PdfReader pdfFormReader = PrintUtil.createPdfFromForms(input, printEntries);
        PdfReader engineFormReader = PrintUtil.createPdfFromEngine(session, localizationHelper, imageSource, printEntries, rendererConfiguration);
        File mergedTempFile = PrintUtil.mergeIntoTempFile(pdfFormReader, engineFormReader);
        PrintUtil.tryClose(pdfFormReader);
        PrintUtil.tryClose(engineFormReader);
        File pdfFile = File.createTempFile(PDF_PREFIX, PDF_SUFFIX, targetDirectory);
        Files.move(mergedTempFile.toPath(), pdfFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return pdfFile;
    }

    private static void tryClose(@Nullable PdfReader reader) {
        if (reader != null) {
            reader.close();
        }
    }

    public static @Nullable PdfReader createPdfFromEngine(DvbTaxSession session, LocalizationHelper localizationHelper, ImageSource imageSource, List<PrintEntry> printEntries, @NonNull FormRendererConfiguration rendererConfig) throws InterruptedException, IOException {
        ArrayList<FormKey> keys = new ArrayList<FormKey>(printEntries.size());
        for (PrintEntry printEntry : printEntries) {
            if (!printEntry.isFormularEnabled() || printEntry.getFormKey() == null) continue;
            keys.add(printEntry.getFormKey());
        }
        if (keys.isEmpty()) {
            return null;
        }
        AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(localizationHelper, Objects.requireNonNull(session.getDataModel()), null);
        PrintRequest printRequest = new PrintRequest(ctx, imageSource).withFormKeys(keys).withConfiguration(rendererConfig);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            PrintUtil.print(session, printRequest, os);
        }
        catch (FormRendererException e) {
            throw new IllegalStateException("Error printing " + Arrays.toString(printEntries.toArray()), e);
        }
        os.flush();
        byte[] bytes = os.toByteArray();
        return new PdfReader(bytes);
    }

    public static @NonNull Map<DokumentId, byte[]> createPdfFromFormsPerDokument(@NonNull PdfPrinterInput input, @NonNull Collection<PrintEntry> printEntries) throws PdfFormException, IOException, MalformedURLException {
        ArrayList<PdfForm> pdfForms = new ArrayList<PdfForm>(printEntries.size());
        for (PrintEntry printEntry : printEntries) {
            if (!printEntry.isFormularEnabled() || printEntry.getPageList() == null) continue;
            pdfForms.addAll(printEntry.getPageList());
        }
        if (pdfForms.isEmpty()) {
            return Collections.emptyMap();
        }
        DvbTaxPdfFormPrinter printer = new DvbTaxPdfFormPrinter();
        MultiValuedMap<DokumentId, Page> pages = printer.createPages(input.withPdfForms(pdfForms));
        ArrayList dokumentIds = new ArrayList(pages.keySet());
        Collections.sort(dokumentIds);
        ArrayListValuedHashMap groupedByDokLN = new ArrayListValuedHashMap(pages.size());
        for (DokumentId dokumentId : dokumentIds) {
            Collection currentPages = pages.get((Object)dokumentId);
            groupedByDokLN.putAll((Object)new DokumentId(dokumentId.getDokument(), dokumentId.getLnDokument()), (Iterable)currentPages);
        }
        HashMap<DokumentId, byte[]> result = new HashMap<DokumentId, byte[]>();
        for (DokumentId dokumentId : groupedByDokLN.keySet()) {
            ArrayList pageList = new ArrayList(groupedByDokLN.get((Object)dokumentId));
            byte[] pdfFormBytes = new PdfFormFiller().createPDF(pageList, true);
            result.put(dokumentId, pdfFormBytes);
        }
        return result;
    }

    public static @Nullable PdfReader createPdfFromForms(@NonNull PdfPrinterInput input, @NonNull Collection<PrintEntry> printEntries) throws PdfFormException, IOException, MalformedURLException {
        ArrayList<PdfForm> pdfForms = new ArrayList<PdfForm>(printEntries.size());
        for (PrintEntry printEntry : printEntries) {
            if (!printEntry.isFormularEnabled() || printEntry.getPageList() == null) continue;
            pdfForms.addAll(printEntry.getPageList());
        }
        if (pdfForms.isEmpty()) {
            return null;
        }
        DvbTaxPdfFormPrinter printer = new DvbTaxPdfFormPrinter();
        MultiValuedMap<DokumentId, Page> pages = printer.createPages(input.withPdfForms(pdfForms));
        List<Page> pageList = PrintUtil.flattenPagesSorted(pages);
        byte[] pdfFormBytes = new PdfFormFiller().createPDF(pageList, true);
        return new PdfReader(pdfFormBytes);
    }

    public static @NonNull List<Page> flattenPagesSorted(@NonNull MultiValuedMap<DokumentId, Page> pages) {
        ArrayList<Page> result = new ArrayList<Page>(pages.size());
        ArrayList keys = new ArrayList(pages.keySet());
        Collections.sort(keys);
        for (DokumentId key : keys) {
            result.addAll(pages.get((Object)key));
        }
        return result;
    }
}

