/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.html;

import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.presentation.common.print.FormRenderer;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.FormRendererUtil;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.DisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.NotYetImplementedException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HtmlFormRenderer
extends FormRenderer {
    private PrintWriter out;

    public HtmlFormRenderer(FormRendererConfiguration configuration,  @NonNull AbstractConverter.ConverterContext ctx, ImageSource imgSrc) {
        super(configuration, ctx, imgSrc);
    }

    public void render(ExpertDisplayModelItem form, OutputStream os) {
        throw new NotYetImplementedException();
    }

    protected void handleItem(ExpertDisplayInfoDTO.ImageDTO item) {
        this.out.print("<div style=\"");
        this.out.print("position:absolute; ");
        this.out.print("left:" + item.getX() + "px; ");
        this.out.print("top:" + item.getY() + "px; ");
        this.out.print("width:" + item.getWidth() + "px; ");
        this.out.print("border-style:double;");
        this.out.println("\">");
        this.out.println("<img src=\"" + item.getFileName() + "\" width=\"" + item.getWidth() + "\" height=\"" + item.getHeight() + "\"");
        this.out.println("</div>");
    }

    protected void handleItem(ExpertDisplayInfoDTO.TextItemDTO item) {
        this.out.print("<div style=\"");
        this.out.print("position:absolute; ");
        this.out.print("left:" + item.getX() + "px; ");
        this.out.print("top:" + item.getY() + "px; ");
        this.out.print("width:" + item.getWidth() + "px; ");
        this.out.print("background-color:" + item.getBgColor().toString() + "; ");
        this.out.print("border-bottom-style:none; ");
        this.out.print("padding:5px; ");
        this.out.print("text-align:left;");
        this.out.println("\">");
        this.out.print("<span style=\"font-family:'" + item.getFont().getName() + "'; font-size:'" + item.getFont().getSize() + "px'\">");
        this.out.print(FormRendererUtil.getText(item, this.getConverterContext()));
        this.out.println("</span>");
        this.out.println("</div>");
    }

    @Override
    public void render(List<? extends DisplayInfoDTO> forms, OutputStream os) {
        throw new NotYetImplementedException();
    }
}

