/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf;

import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Template;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.HyphenationAuto;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DocumentContext {
    private final @NonNull Document document;
    private final @NonNull PdfWriter writer;
    private final  @NonNull AbstractConverter.ConverterContext globalConverterContext;
    private final @NonNull ImageSource imgSource;
    private final @NonNull Collection<ExpertDisplayInfoDTO.ItemDTO> extraItems = new ArrayList<ExpertDisplayInfoDTO.ItemDTO>();
    private final HyphenationAuto hypenation;
    private final @NonNull Collection<Template> templates = new ArrayList<Template>();
    private final @NonNull Map<String, PdfOutline> outlines = new HashMap<String, PdfOutline>();
    private final @NonNull Map<String, Object> properties;
    private final long timestamp;
    private final @NonNull FormRendererConfiguration configuration;
    private ExpertDisplayInfoDTO.PageSettingsDTO pageSettings = null;
    private float valuePaddingHorizontal;
    private float valuePaddingVertical;
    private int formPage;
    private int formPages;

    public DocumentContext(Document document, PdfWriter writer,  @NonNull AbstractConverter.ConverterContext globalConverterContext, ImageSource imgSource, FormRendererConfiguration configuration) {
        this.document = Objects.requireNonNull(document);
        this.writer = Objects.requireNonNull(writer);
        this.globalConverterContext = Objects.requireNonNull(globalConverterContext);
        this.imgSource = Objects.requireNonNull(imgSource);
        this.configuration = Objects.requireNonNull(configuration);
        this.properties = Collections.unmodifiableMap(configuration.getProperties());
        try {
            String lang = globalConverterContext.getLocalizationHelper().getCurrentLocale().getLanguage();
            this.hypenation = new HyphenationAuto(lang, null, 2, 2);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new RuntimeException("hyphenation initialization failed", e);
        }
        Long timestampProvided = configuration.getTimestamp();
        this.timestamp = timestampProvided != null ? timestampProvided : System.currentTimeMillis();
    }

    public @NonNull Document getDocument() {
        return this.document;
    }

    public @NonNull PdfWriter getWriter() {
        return this.writer;
    }

    public  @NonNull AbstractConverter.ConverterContext getGlobalConverterContext() {
        return this.globalConverterContext;
    }

    public ImageSource getImageSource() {
        return this.imgSource;
    }

    public @NonNull Collection<ExpertDisplayInfoDTO.ItemDTO> getExtraItems() {
        return this.extraItems;
    }

    public void addExtraItem(ExpertDisplayInfoDTO.ItemDTO item) {
        if (item == null) {
            throw new NullPointerException("item must not be null");
        }
        this.extraItems.add(item);
    }

    public int getFormPage() {
        return this.formPage;
    }

    public void setFormPage(int formPage) {
        this.formPage = formPage;
    }

    public int getFormPages() {
        return this.formPages;
    }

    public void setFormPages(int formPages) {
        this.formPages = formPages;
    }

    public HyphenationEvent getHyphenation() {
        return this.hypenation;
    }

    public @NonNull Collection<Template> getTemplates() {
        return this.templates;
    }

    public void addTemplate(Template temp) {
        this.templates.add(temp);
    }

    public boolean isUseBoldFonts() {
        return this.configuration.isUseBoldFonts();
    }

    public void setValuePaddingX(float valuePaddingX) {
        this.valuePaddingHorizontal = valuePaddingX;
    }

    public void setValuePaddingY(float valuePaddingY) {
        this.valuePaddingVertical = valuePaddingY;
    }

    public float getValuePaddingX() {
        return this.valuePaddingHorizontal;
    }

    public float getValuePaddingY() {
        return this.valuePaddingVertical;
    }

    public void setPageSettings(ExpertDisplayInfoDTO.PageSettingsDTO pageSettings) {
        this.pageSettings = pageSettings;
    }

    public ExpertDisplayInfoDTO.PageSettingsDTO getPageSettings() {
        return this.pageSettings;
    }

    public @NonNull Map<String, PdfOutline> getOutlines() {
        return this.outlines;
    }

    public @NonNull Map<String, Object> getProperties() {
        return this.properties;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

