/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.Barcode39;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Barcode1DPrinter
extends ExpertItemPrinter<ExpertDisplayInfoDTO.Barcode1DDTO> {
    private ExpertDisplayInfoDTO.Barcode1DDTO item;

    @Override
    protected void initalize( @NonNull ExpertDisplayInfoDTO.Barcode1DDTO item) {
        this.item = item;
    }

    @Override
    public void printInternal(float xOffset, float yOffset) throws FormRendererException {
        ModelItemDTO sourceMiDTO = this.item.getModelItem();
        if (sourceMiDTO.getState() == 12) {
            return;
        }
        Barcode39 bc = switch (this.item.getType()) {
            case 1 -> new Barcode39();
            case 2 -> new Barcode128();
            default -> throw new IllegalArgumentException("invalid barcode 1D type: " + this.item.getType());
        };
        bc.setStartStopText(false);
        Object value = sourceMiDTO.getValue();
        String text = value == null ? "" : value.toString();
        DocumentContext ctx = this.getDocumentContext();
        text = text.replaceAll("@formpage@", Integer.toString(ctx.getFormPage()));
        text = text.replaceAll("@extrapage@", Integer.toString(ctx.getFormPage() - 1));
        bc.setCode(text);
        if (this.item.getBarHeight() >= 0) {
            bc.setBarHeight((float)this.item.getBarHeight());
        }
        if (this.item.getMinBarWidth() >= 0.0f) {
            bc.setX(this.item.getMinBarWidth());
        }
        if (this.item.getRelBarWidth() >= 0.0f) {
            bc.setN(this.item.getRelBarWidth());
        }
        if (this.item.getTextSize() >= 0) {
            bc.setSize((float)this.item.getTextSize());
        }
        Image image = bc.createImageWithBarcode(this.getDirectContent(), null, null);
        image.setAbsolutePosition((float)this.item.getX(), this.getPageSize().getHeight() - image.getHeight() - (float)this.item.getY());
        try {
            this.getDirectContent().addImage(image);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't add barcode image to document", e);
        }
    }
}

