/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TableAdditionItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TablePrinter;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.Iterator;

public class GridTablePrinter
extends TablePrinter {
    @Override
    protected void printStandardTable(float xOffset, float yOffset) throws FormRendererException {
        try {
            ExpertDisplayInfoDTO.TableDTO tableDTO = this.item;
            PdfPTable table = this.prepareTableWithHeaders(tableDTO);
            this.prepareRows(tableDTO, table);
            this.getDocumentContext().getDocument().add((Element)table);
            if (this.rowNo < this.item.getPrintRows().size() && this.rowNo < this.item.getEndRow()) {
                this.addExtraItem(new TableAdditionItem(this.item, this.rowNo));
            }
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new FormRendererException("can't print additional table", e);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print additional table", e);
        }
    }

    protected PdfPTable prepareTableWithHeaders(ExpertDisplayInfoDTO.TableDTO tableDTO) throws FormRendererException {
        int colCnt = tableDTO.getPrintColumns().size();
        PdfPTable table = new PdfPTable(colCnt);
        table.setWidthPercentage(100.0f);
        table.setHeaderRows(2);
        this.addTitleCell(tableDTO, table, colCnt);
        this.prepareColumnHeaders(colCnt, tableDTO, table);
        return table;
    }

    private void addTitleCell(ExpertDisplayInfoDTO.TableDTO tableDTO, PdfPTable table, int colCnt) throws FormRendererException {
        Font titleFont = this.itextFont(tableDTO.getTitleFont());
        Paragraph title = new Paragraph(this.getGlobalConverterContext().getLocalizationHelper().translate(tableDTO.getTitle(), new Object[0]), titleFont);
        PdfPCell cellTitle = new PdfPCell((Phrase)title);
        cellTitle.setColspan(colCnt);
        cellTitle.setBorderColor(GridTablePrinter.awtColor(tableDTO.getBorderColor()));
        table.addCell(cellTitle);
    }

    protected void prepareColumnHeaders(int colCnt, ExpertDisplayInfoDTO.TableDTO tableDTO, PdfPTable table) throws FormRendererException {
        float[] colWidths = new float[colCnt];
        int j = 0;
        Iterator<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> iterator = tableDTO.getPrintColumns().iterator();
        while (iterator.hasNext()) {
            ExpertDisplayInfoDTO.TableDTO.ColumnDTO element;
            ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = element = iterator.next();
            String colTitleTranslated = "";
            if (col.getTitle() != null) {
                colTitleTranslated = this.getGlobalConverterContext().getLocalizationHelper().translate(col.getTitle(), new Object[0]);
            }
            Chunk colTitle = new Chunk(colTitleTranslated);
            colTitle.setFont(this.itextFont(col.getFont()));
            colTitle.setHyphenation(this.getDocumentContext().getHyphenation());
            PdfPCell cell = new PdfPCell(new Phrase(colTitle));
            cell.setBorderColor(GridTablePrinter.awtColor(tableDTO.getBorderColor()));
            cell.setHorizontalAlignment(col.getAlignment());
            table.addCell(cell);
            colWidths[j++] = (float)col.getWidth() / (float)tableDTO.getWidth();
        }
        table.setWidths(colWidths);
    }

    protected void prepareRows(ExpertDisplayInfoDTO.TableDTO tableDTO, PdfPTable table) throws FormRendererException {
        int rowsToPrint = Math.min(this.item.getFormRows(), tableDTO.getPrintRows().size());
        while (this.rowNo < rowsToPrint) {
            ExpertDisplayInfoDTO.TableDTO.RowDTO row = tableDTO.getPrintRows().get(this.rowNo);
            int colNo = 0;
            for (ExpertDisplayInfoDTO.TableDTO.ColumnDTO col : tableDTO.getPrintColumns()) {
                if (colNo >= row.getValues().size()) continue;
                ExpertDisplayInfoDTO.TableDTO.CellDTO cell = (ExpertDisplayInfoDTO.TableDTO.CellDTO)row.getValues().get(colNo);
                Chunk ck = new Chunk(this.getText(col, cell));
                ck.setFont(this.itextFont(cell.getFont()));
                PdfPCell pdfCell = new PdfPCell(new Phrase(ck));
                pdfCell.setBorderColor(GridTablePrinter.awtColor(tableDTO.getBorderColor()));
                pdfCell.setPaddingTop(tableDTO.getExtraPagesRowPadding());
                pdfCell.setHorizontalAlignment(GridTablePrinter.itextAlignment(col.getAlignment()));
                table.addCell(pdfCell);
                ++colNo;
            }
            ++this.rowNo;
        }
    }
}

