/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DokumentId
implements Serializable,
Comparable<DokumentId> {
    private static final long serialVersionUID = 3679451942473455066L;
    private final @NonNull String sortKeyPrefix;
    private final int dokument;
    private final int lnDokument;
    private final @NonNull String sortKeySuffix;

    public DokumentId(int dokument, int lnDokument) {
        this("", dokument, lnDokument, "");
    }

    public DokumentId(@NonNull String sortKeyPrefix, int dokument, int lnDokument, @NonNull String sortKeySuffix) {
        this.sortKeyPrefix = Objects.requireNonNull(sortKeyPrefix);
        this.dokument = dokument;
        this.lnDokument = lnDokument;
        this.sortKeySuffix = Objects.requireNonNull(sortKeySuffix);
    }

    public @NonNull DokumentId withSortKeyPrefix(@NonNull String sortKeyPrefix) {
        Objects.requireNonNull(sortKeyPrefix);
        return new DokumentId(sortKeyPrefix, this.getDokument(), this.getLnDokument(), this.getSortKeySuffix());
    }

    public @NonNull DokumentId withSortKeySuffix(@NonNull String sortKeySuffix) {
        Objects.requireNonNull(sortKeySuffix);
        return new DokumentId(this.getSortKeyPrefix(), this.getDokument(), this.getLnDokument(), sortKeySuffix);
    }

    @Override
    public int compareTo(@NonNull DokumentId o) {
        return new CompareToBuilder().append((Object)this.getSortKeyPrefix(), (Object)o.getSortKeyPrefix()).append(this.getDokument(), o.getDokument()).append(this.getLnDokument(), o.getLnDokument()).append((Object)this.getSortKeySuffix(), (Object)o.getSortKeySuffix()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DokumentId)) {
            return false;
        }
        return this.compareTo((DokumentId)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.getSortKeyPrefix(), this.getDokument(), this.getLnDokument(), this.getSortKeySuffix());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.sortKeyPrefix).append(this.dokument).append(this.lnDokument).append((Object)this.sortKeySuffix).build();
    }

    public @NonNull String getSortKeyPrefix() {
        return this.sortKeyPrefix;
    }

    public int getDokument() {
        return this.dokument;
    }

    public int getLnDokument() {
        return this.lnDokument;
    }

    public @NonNull String getSortKeySuffix() {
        return this.sortKeySuffix;
    }
}

