/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform;

import ch.dvbern.lib.pdfforms.FormattingParams;
import ch.dvbern.lib.pdfforms.Page;
import ch.dvbern.lib.pdfforms.PdfField;
import ch.dvbern.lib.pdfforms.PdfFormFieldParser;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LMKTableTree;
import ch.dvbern.tax.common.engine.LMKTreeNode;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.DokumentId;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfFieldBag;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfForm;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfFormException;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfPrinterInput;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfStructure;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfTableMerge;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfValue;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.RunContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.TableRow;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.NOPResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.PdfKey;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.Resolver;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DvbTaxPdfFormPrinter {
    private static final Logger LOG = LoggerFactory.getLogger(DvbTaxPdfFormPrinter.class);

    public @NonNull MultiValuedMap<DokumentId, Page> createPages(@NonNull PdfPrinterInput pdfPrinterInput) throws PdfFormException {
        ArrayListValuedHashMap filledPDFPages = new ArrayListValuedHashMap();
        for (PdfForm pdfFormPage : pdfPrinterInput.getPdfForms()) {
            try {
                RunContext ctx = new RunContext(pdfPrinterInput);
                filledPDFPages.putAll(this.createPages(pdfFormPage, ctx));
            }
            catch (RuntimeException rte) {
                throw new PdfFormException("Error filling in page: " + String.valueOf(pdfFormPage), rte);
            }
        }
        return filledPDFPages;
    }

    private @NonNull MultiValuedMap<DokumentId, Page> createPages(@NonNull PdfForm pdfForm, @NonNull RunContext ctx) {
        try {
            PdfStructure pdfStructure = this.parseForm(pdfForm, ctx);
            return this.fillFormWithExtrapages(pdfStructure, ctx);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not fill: " + String.valueOf(pdfForm), e);
        }
    }

    private MultiValuedMap<DokumentId, Page> fillFormWithExtrapages(@NonNull PdfStructure structure, @NonNull RunContext ctx) {
        PdfFieldBag form = structure.getMainForm();
        PdfForm pdfForm = structure.getPdfForm();
        FormattingParams formattingParams = FormattingParams.newBuilder((URL)pdfForm.getPdfTemplate(), (Locale)ctx.getInput().getLocalizationHelper().getCurrentLocale()).withPageNumberingAlgo(ctx.getInput().getPageNumberingAlgo()).withPostProcessors(structure.getPdfForm().getPostProcessors()).build();
        HashSet<LMK> looping = new HashSet<LMK>(form.getTableLMKs());
        if (looping.isEmpty()) {
            Page singlePage = new Page(formattingParams);
            this.fillPageFromFields(pdfForm, singlePage, form.getFields(), null, ctx);
            DokumentId singlePageDokumentId = this.supplyDokumentId(ctx, structure, null);
            ArrayListValuedHashMap pages = new ArrayListValuedHashMap();
            pages.put((Object)singlePageDokumentId, (Object)singlePage);
            return pages;
        }
        Page mainPage = new Page(formattingParams);
        DokumentId mainDokumentId = this.supplyDokumentId(ctx, structure, null);
        boolean pagesPrinted = false;
        ArrayListValuedHashMap overflows = new ArrayListValuedHashMap();
        for (LMK tableLMK : looping) {
            LinkedList<TableRow> leftoverNestedRows;
            List<TableRow> tableRows = this.findRowDMKs(pdfForm, tableLMK, null, ctx);
            this.removeDisabledPdfForms(ctx, pdfForm, tableRows);
            if (tableRows.isEmpty() && !pdfForm.isFirstPageAlwaysPrinted()) continue;
            pagesPrinted = true;
            Map<DMK, List<TableRow>> nestedTableRows = this.findNestedTableRows(ctx, pdfForm, tableLMK, tableRows);
            this.fillPageFromFields(pdfForm, mainPage, form.getFields(), null, ctx);
            if (tableRows.isEmpty()) continue;
            DMK dmk = tableRows.get(0).getTableRowDMK();
            mainDokumentId = this.supplyDokumentId(ctx, structure, dmk);
            Pair<List<TableRow>, List<TableRow>> leftOverLists = this.fillPageRowsFromFields(pdfForm, mainPage, form, tableLMK, tableRows, nestedTableRows, null, ctx);
            List leftoverRows = (List)leftOverLists.getLeft();
            List list = leftoverNestedRows = leftOverLists.getRight() == null ? new LinkedList() : (List)leftOverLists.getRight();
            while (!leftoverRows.isEmpty()) {
                DokumentId overflowDokumentId = this.supplyDokumentId(ctx, structure, ((TableRow)leftoverRows.get(0)).getTableRowDMK());
                Pair<List<TableRow>, Page> result = this.fillOverflowPage(structure, tableLMK, leftoverRows, nestedTableRows, leftoverNestedRows, ctx);
                leftoverRows = (List)result.getLeft();
                overflows.put((Object)overflowDokumentId, (Object)((Page)result.getRight()));
            }
        }
        ArrayListValuedHashMap pages = new ArrayListValuedHashMap();
        if (!pagesPrinted) {
            return pages;
        }
        Objects.requireNonNull(mainDokumentId, "mainDokumentId wurde nicht ermittelt: " + String.valueOf(looping));
        pages.put((Object)mainDokumentId, (Object)mainPage);
        pages.putAll((MultiValuedMap)overflows);
        return pages;
    }

    private @NonNull DokumentId supplyDokumentId(@NonNull RunContext ctx, @NonNull PdfStructure structure, @Nullable DMK rowDMK) {
        return structure.getPdfForm().getDokumentIdSupplier().supplyDokumentId(ctx, rowDMK);
    }

    private void removeDisabledPdfForms(@NonNull RunContext ctx, @NonNull PdfForm pdfForm, @NonNull List<TableRow> tableRows) {
        Iterator<TableRow> iter = tableRows.iterator();
        while (iter.hasNext()) {
            TableRow row = iter.next();
            if (pdfForm.getEnabledSupplier().isEnabled(ctx, row.getTableRowDMK())) continue;
            iter.remove();
        }
    }

    private @NonNull Map<DMK, List<TableRow>> findNestedTableRows(@NonNull RunContext ctx, @NonNull PdfForm pdfForm, @NonNull LMK tableLMK, @NonNull List<TableRow> tableRows) {
        HashMap<DMK, List<TableRow>> nestedTableRows = new HashMap<DMK, List<TableRow>>();
        LMKTableTree lmkTreeNode = new LMKTableTree(ctx.getInput().getLogicModelItems());
        LMKTreeNode tableNode = lmkTreeNode.findTableNode(tableLMK);
        if (tableNode != null) {
            Map<LMK, LMKTreeNode> nestedTables = tableNode.getChildTables();
            for (TableRow row : tableRows) {
                for (Map.Entry<LMK, LMKTreeNode> nestedTableEntry : nestedTables.entrySet()) {
                    nestedTableRows.put(row.getTableRowDMK(), this.findRowDMKs(pdfForm, nestedTableEntry.getKey(), row.getTableRowDMK(), ctx));
                }
            }
        }
        return nestedTableRows;
    }

    private @NonNull List<TableRow> findRowDMKs(@NonNull PdfForm pdfForm, @NonNull LMK tableLMK, @Nullable DMK parent, @NonNull RunContext ctx) {
        ArrayList<TableRow> result = new ArrayList<TableRow>();
        DMK tableDMK = tableLMK.toRootlevelDMK();
        if (null != parent) {
            tableDMK = DMK.parse(EngineUtil.mergeModelKey(tableLMK, parent));
        }
        Set dataModelRowSet = tableDMK.findRowDMKs(ctx.getInput().getDataModelMap()).orElse(Collections.emptySet());
        for (DMK dmk : dataModelRowSet) {
            result.add(new TableRow(dmk, Collections.emptyMap()));
        }
        PdfTableMerge tableMerge = pdfForm.getTableMerges(tableLMK);
        if (tableMerge != null) {
            for (Map.Entry<LMK, Map<LMK, LMK>> mappedTableEntry : tableMerge.getColumMapping().entrySet()) {
                LMK mappedTable = mappedTableEntry.getKey();
                Map<LMK, LMK> columnMapping = mappedTableEntry.getValue();
                Set mergeTableRowSet = mappedTable.toRootlevelDMK().findRowDMKs(ctx.getInput().getDataModelMap()).orElse(Collections.emptySet());
                for (DMK dmk : mergeTableRowSet) {
                    result.add(new TableRow(dmk, columnMapping));
                }
            }
        }
        Collections.sort(result);
        return result;
    }

    private @NonNull Pair<List<TableRow>, Page> fillOverflowPage(@NonNull PdfStructure structure, @NonNull LMK tableLMK, @NonNull List<TableRow> tableRows, @NonNull Map<DMK, List<TableRow>> nestedTableRows, @NonNull List<TableRow> leftOverNestedRows, @NonNull RunContext ctx) {
        Objects.requireNonNull(structure);
        Objects.requireNonNull(tableLMK);
        Objects.requireNonNull(tableRows);
        Objects.requireNonNull(nestedTableRows);
        Objects.requireNonNull(ctx);
        PdfForm pdfForm = structure.getPdfForm();
        Map<LMK, PdfFieldBag> extraPages = structure.getExtraPages();
        PdfForm overflowPdfForm = pdfForm.getOverflowPages().get(tableLMK);
        TableRow tableRow = null;
        if (!leftOverNestedRows.isEmpty()) {
            overflowPdfForm = pdfForm.getOverflowPages().get(leftOverNestedRows.get(0).getTableRowDMK().toLMK());
            tableRow = leftOverNestedRows.get(0);
        }
        PdfFieldBag pdfFieldBag = null;
        pdfFieldBag = null == extraPages.get(tableLMK) ? structure.getMainForm() : Objects.requireNonNull(extraPages.get(tableLMK), "Could not find extraPages for: " + String.valueOf(tableLMK));
        if (null == overflowPdfForm) {
            overflowPdfForm = pdfForm;
        }
        FormattingParams formattingParams = FormattingParams.newBuilder((URL)overflowPdfForm.getPdfTemplate(), (Locale)ctx.getInput().getLocalizationHelper().getCurrentLocale()).withPageNumberingAlgo(ctx.getInput().getPageNumberingAlgo()).withPostProcessors(pdfForm.getPostProcessors()).build();
        Page page = new Page(formattingParams);
        Set<PdfField> fields = null;
        fields = pdfFieldBag.getFields();
        this.fillPageFromFields(overflowPdfForm, page, fields, tableRow, ctx);
        Pair<List<TableRow>, List<TableRow>> leftOverlists = this.fillPageRowsFromFields(overflowPdfForm, page, pdfFieldBag, tableLMK, tableRows, nestedTableRows, leftOverNestedRows, ctx);
        List leftovers = (List)leftOverlists.getLeft();
        List leftoverNestedRows = (List)leftOverlists.getRight();
        if (null == leftoverNestedRows || !leftoverNestedRows.isEmpty()) {
            // empty if block
        }
        return Pair.of((Object)leftovers, (Object)page);
    }

    private @NonNull Pair<List<TableRow>, List<TableRow>> fillPageRowsFromFields(@NonNull PdfForm pdfForm, @NonNull Page page, @NonNull PdfFieldBag form, @NonNull LMK tableLMK, @NonNull List<TableRow> tableRows, @NonNull Map<DMK, List<TableRow>> nestedTableRows, @Nullable List<TableRow> nestedLefOverRows, @NonNull RunContext ctx) {
        SortedMap<Integer, Set<PdfField>> pdfFields = form.getRowsForTable(tableLMK, ctx);
        if (pdfFields.isEmpty()) {
            throw new IllegalArgumentException("There are not rows for table: " + String.valueOf(tableLMK) + " in form " + String.valueOf(pdfForm));
        }
        List<TableRow> leftOverNestedRows = nestedLefOverRows;
        for (Map.Entry<Integer, Set<PdfField>> pdfRowEntry : pdfFields.entrySet()) {
            if (tableRows.isEmpty()) break;
            TableRow tableRow = tableRows.get(0);
            DMK tableRowDMK = tableRow.getTableRowDMK();
            Set<PdfField> fields = pdfRowEntry.getValue();
            leftOverNestedRows = nestedTableRows.get(tableRowDMK);
            this.fillPageFromFields(pdfForm, page, fields, tableRow, ctx);
            if (null != leftOverNestedRows && !leftOverNestedRows.isEmpty()) {
                Iterator<TableRow> rowIterater = leftOverNestedRows.iterator();
                TableRow nestedRow = rowIterater.next();
                SortedMap<Integer, Set<PdfField>> nestedPdfFields = form.getRowsForTable(nestedRow.getTableRowDMK().toLMK(), ctx);
                for (Map.Entry<Integer, Set<PdfField>> nestedPdfRowEntry : nestedPdfFields.entrySet()) {
                    Set<PdfField> nestedFields = nestedPdfRowEntry.getValue();
                    this.fillPageFromFields(pdfForm, page, nestedFields, nestedRow, ctx);
                    rowIterater.remove();
                    if (!rowIterater.hasNext()) break;
                    nestedRow = rowIterater.next();
                }
                if (nestedPdfFields.isEmpty()) {
                    leftOverNestedRows = null;
                }
            }
            if (leftOverNestedRows != null && !leftOverNestedRows.isEmpty()) continue;
            tableRows.remove(0);
        }
        return Pair.of(tableRows, leftOverNestedRows);
    }

    private void fillPageFromFields(@NonNull PdfForm pdfForm, @NonNull Page page, @NonNull Set<PdfField> fields, @Nullable TableRow tableRow, @NonNull RunContext ctx) {
        for (PdfField field : fields) {
            try {
                PdfKey pdfKey = PdfKey.parseSimpleUri(field.getName());
                Resolver resolver = this.getSupportedResolver(pdfKey, ctx);
                page.embedFontFiles(resolver.getFonts());
                boolean valid = resolver.validate(pdfKey, tableRow, ctx);
                if (!valid) {
                    LOG.error("Not a valid field: {} in form {}, resolver: {}", new Object[]{field, pdfForm, resolver});
                    continue;
                }
                @Nullable Object value = resolver.resolve(pdfKey, tableRow, pdfForm, ctx);
                String textValue = resolver.formatValue(pdfKey, tableRow, new PdfValue(value), ctx);
                page.putField(field.getName(), textValue);
            }
            catch (RuntimeException rte) {
                throw new IllegalStateException("Could not process field: " + String.valueOf(pdfForm) + "@" + String.valueOf(field), rte);
            }
        }
    }

    private @NonNull Resolver getSupportedResolver(@NonNull PdfKey pdfKey, @NonNull RunContext ctx) {
        for (Resolver resolver : ctx.getInput().getResolvers()) {
            if (!resolver.supports(pdfKey)) continue;
            return resolver;
        }
        LOG.error("Could not find resolver for field: {}", (Object)pdfKey);
        return new NOPResolver();
    }

    private @NonNull PdfStructure parseForm(@NonNull PdfForm pdfForm, @NonNull RunContext ctx) throws IOException {
        PdfFieldBag pdfFieldBag = this.parseDvbTaxForm(pdfForm, ctx);
        Map<LMK, PdfFieldBag> extraPages = this.parseDvbTaxFormExtrapages(pdfForm, ctx);
        return new PdfStructure(pdfForm, pdfFieldBag, extraPages);
    }

    private @NonNull Map<LMK, PdfFieldBag> parseDvbTaxFormExtrapages(@NonNull PdfForm pdfForm, @NonNull RunContext ctx) throws IOException {
        HashMap<LMK, PdfFieldBag> pages = new HashMap<LMK, PdfFieldBag>();
        for (Map.Entry<LMK, PdfForm> entry : pdfForm.getOverflowPages().entrySet()) {
            LMK tableLMK = entry.getKey();
            PdfFieldBag pdfFieldBag = this.parseDvbTaxForm(entry.getValue(), ctx);
            pages.put(tableLMK, pdfFieldBag);
        }
        return pages;
    }

    private @NonNull PdfFieldBag parseDvbTaxForm(@NonNull PdfForm pdfForm, @NonNull RunContext ctx) throws IOException {
        PdfFormFieldParser fieldParser = ctx.getPdfFormFieldParser();
        NavigableSet pdfFields = fieldParser.parsePdfFieldNames(pdfForm.getPdfTemplate());
        PdfFieldBag.Builder builder = PdfFieldBag.builder();
        for (PdfField pdfFieldID : pdfFields) {
            try {
                PdfKey pdfKey = PdfKey.parseSimpleUri(pdfFieldID.getName());
                Resolver resolver = this.getSupportedResolver(pdfKey, ctx);
                @Nullable LMK tableLMK = resolver.tableLMK(pdfKey, ctx);
                if (tableLMK != null) {
                    builder.withTableField(tableLMK, pdfFieldID);
                    continue;
                }
                builder.withField(pdfFieldID);
            }
            catch (Exception e) {
                LOG.error("Error parsing {} in form {}", (Object)pdfFieldID, (Object)pdfForm);
            }
        }
        return builder.build();
    }
}

