/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform;

import ch.dvbern.lib.pdfforms.processing.ProcessorOperation;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.DokumentId;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.DokumentIdSupplier;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.EnabledSupplier;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfFormPage;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfTableMerge;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.RunContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PdfForm
extends PdfFormPage {
    private final @NonNull Map<LMK, PdfForm> overflowPages;
    private final @NonNull Map<LMK, PdfTableMerge> tableMerges;
    private final @NonNull List<ProcessorOperation> postProcessors;
    private final @NonNull EnabledSupplier enabledSupplier;
    private final @NonNull DokumentIdSupplier dokumentIdSupplier;
    private final boolean firstPageAlwaysPrinted;

    public boolean isFirstPageAlwaysPrinted() {
        return this.firstPageAlwaysPrinted;
    }

    public PdfForm(@NonNull URL pdfVorlage, @NonNull EnabledSupplier enabledSupplier, @NonNull DokumentIdSupplier dokumentIdSupplier, @Nullable String outlineTitle, @Nullable Map<LMK, PdfForm> overflowPages, @Nullable Collection<PdfTableMerge> tableMerges, @Nullable List<ProcessorOperation> postProcessors, boolean firstPageAlwaysPrinted) {
        super(pdfVorlage, outlineTitle);
        this.enabledSupplier = Objects.requireNonNull(enabledSupplier);
        this.dokumentIdSupplier = Objects.requireNonNull(dokumentIdSupplier);
        this.overflowPages = this.initOverflowPages(overflowPages);
        this.tableMerges = this.initTableMerges(tableMerges);
        this.postProcessors = this.initPostProcessors(postProcessors);
        this.firstPageAlwaysPrinted = firstPageAlwaysPrinted;
    }

    public static Builder newBuilder(@NonNull URL pdfTemplate) {
        return new Builder(pdfTemplate);
    }

    public static Builder newBuilder(@NonNull PdfForm copy) {
        Builder builder = new Builder(copy.getPdfTemplate());
        builder.enabledSupplier = copy.enabledSupplier;
        builder.overflowPages = copy.getOverflowPages();
        builder.tableMerges = new LinkedList<PdfTableMerge>(copy.tableMerges.values());
        builder.postProcessors = copy.getPostProcessors();
        return builder;
    }

    private @NonNull Map<LMK, PdfForm> initOverflowPages(@Nullable Map<LMK, PdfForm> overflowPages) {
        return overflowPages != null ? Collections.unmodifiableMap(overflowPages) : Collections.emptyMap();
    }

    private @NonNull Map<LMK, PdfTableMerge> initTableMerges(@Nullable Collection<PdfTableMerge> tableMerges) {
        HashMap<LMK, PdfTableMerge> merges = new HashMap();
        if (tableMerges == null) {
            merges = Collections.emptyMap();
        } else {
            for (PdfTableMerge merge : tableMerges) {
                merges.put(merge.getBaseTable(), merge);
            }
        }
        return merges;
    }

    private @NonNull List<ProcessorOperation> initPostProcessors(@Nullable Collection<ProcessorOperation> postProcessors) {
        return postProcessors != null ? new ArrayList<ProcessorOperation>(postProcessors) : Collections.emptyList();
    }

    public @NonNull EnabledSupplier getEnabledSupplier() {
        return this.enabledSupplier;
    }

    public @NonNull DokumentIdSupplier getDokumentIdSupplier() {
        return this.dokumentIdSupplier;
    }

    public @NonNull Map<LMK, PdfForm> getOverflowPages() {
        return this.overflowPages;
    }

    public @Nullable PdfTableMerge getTableMerges(@NonNull LMK baseTableLMK) {
        PdfTableMerge tableMerge = this.tableMerges.get(baseTableLMK);
        return tableMerge;
    }

    public @NonNull List<ProcessorOperation> getPostProcessors() {
        return this.postProcessors;
    }

    @Override
    public String toString() {
        StringBuilder sbOverflow = new StringBuilder();
        for (Map.Entry<LMK, PdfForm> entry : this.overflowPages.entrySet()) {
            sbOverflow.append(String.format("[%s->%s]", entry.getKey(), entry.getValue().getPdfTemplate()));
        }
        StringBuilder sbMerge = new StringBuilder();
        for (Map.Entry<LMK, PdfTableMerge> entry : this.tableMerges.entrySet()) {
            sbMerge.append(String.format("[%s->%s]", entry.getKey(), entry.getValue()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ProcessorOperation postProcessor : this.postProcessors) {
            stringBuilder.append(String.format("[%s]", postProcessor));
        }
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("overflowPages", (Object)sbOverflow.toString()).append("tableMerges", (Object)sbMerge.toString()).append("postProcessors", (Object)stringBuilder.toString()).append("enabledSuplier", (Object)this.enabledSupplier.toString()).toString();
    }

    public static final class Builder {
        private final @NonNull URL pdfTemplate;
        private @NonNull String outlineTitle = "";
        private boolean firstPageAlwaysPrinted = true;
        private @NonNull Map<LMK, PdfForm> overflowPages = new HashMap<LMK, PdfForm>();
        private @NonNull Collection<PdfTableMerge> tableMerges = new LinkedList<PdfTableMerge>();
        private @NonNull List<ProcessorOperation> postProcessors = new ArrayList<ProcessorOperation>();
        private @NonNull EnabledSupplier enabledSupplier = new AlwaysEnabledSupplier();
        private @NonNull DokumentIdSupplier dokumentIdSupplier = new NegativeIdSupplier();

        private Builder(@NonNull URL pdfTemplate) {
            this.pdfTemplate = Objects.requireNonNull(pdfTemplate);
        }

        public @NonNull Builder withOutlineTitle(@NonNull String outlineTitle) {
            this.outlineTitle = Objects.requireNonNull(outlineTitle);
            return this;
        }

        public @NonNull Builder withOverflowPages(@NonNull Map<LMK, PdfForm> val) {
            this.overflowPages = Objects.requireNonNull(val);
            return this;
        }

        public @NonNull Builder withTableMerge(@NonNull PdfTableMerge val) {
            this.tableMerges.add(Objects.requireNonNull(val));
            return this;
        }

        public @NonNull Builder withPostProcessor(@NonNull ProcessorOperation operation) {
            this.postProcessors.add(Objects.requireNonNull(operation));
            return this;
        }

        public @NonNull Builder withEnabledSupplier(@NonNull EnabledSupplier enabledSupplier) {
            this.enabledSupplier = Objects.requireNonNull(enabledSupplier);
            return this;
        }

        public @NonNull Builder withDokumentIdSupplier(@NonNull DokumentIdSupplier dokumentIdSupplier) {
            this.dokumentIdSupplier = Objects.requireNonNull(dokumentIdSupplier);
            return this;
        }

        public @NonNull Builder withFirstPageIsAlwaysPrinted(boolean doPrintFirstPage) {
            this.firstPageAlwaysPrinted = doPrintFirstPage;
            return this;
        }

        public @NonNull Builder withPostProcessors(@NonNull List<ProcessorOperation> postProcessors) {
            this.postProcessors = Objects.requireNonNull(postProcessors);
            return this;
        }

        public @NonNull PdfForm build() {
            return new PdfForm(this.pdfTemplate, this.enabledSupplier, this.dokumentIdSupplier, this.outlineTitle, this.overflowPages, this.tableMerges, this.postProcessors, this.firstPageAlwaysPrinted);
        }
    }

    public static class RowDMKIdSupplier
    implements DokumentIdSupplier {
        private final @NonNull String sortKeyPrefix;
        private final int dokument;
        private final @NonNull String sortKeySuffix;

        public RowDMKIdSupplier(@NonNull String sortKeyPrefix, int dokument, @NonNull String sortKeySuffix) {
            this.sortKeyPrefix = Objects.requireNonNull(sortKeyPrefix);
            this.dokument = dokument;
            this.sortKeySuffix = Objects.requireNonNull(sortKeySuffix);
        }

        public RowDMKIdSupplier(@NonNull String sortKeyPrefix, int dokument) {
            this(sortKeyPrefix, dokument, "");
        }

        @Override
        public DokumentId supplyDokumentId(@NonNull RunContext runContext, @Nullable DMK rowDMK) {
            if (rowDMK == null) {
                return new DokumentId(this.sortKeyPrefix, this.dokument, 1, this.sortKeySuffix);
            }
            DMK dokumentRowDMK = rowDMK.findOutermostTableRowDMK();
            Objects.requireNonNull(dokumentRowDMK);
            int lnDokument = (int)dokumentRowDMK.getRowNum();
            return new DokumentId(this.sortKeyPrefix, this.dokument, lnDokument, this.sortKeySuffix);
        }
    }

    public static class DokumentLn1IdSupplier
    implements DokumentIdSupplier {
        private static final int LN_DOKUMENT = 1;
        private final @NonNull String sortKeyPrefix;
        private final int dokument;
        private final @NonNull String sortKeySuffix;

        public DokumentLn1IdSupplier(@NonNull String sortKeyPrefix, int dokument, @NonNull String sortKeySuffix) {
            this.sortKeyPrefix = Objects.requireNonNull(sortKeyPrefix);
            this.dokument = dokument;
            this.sortKeySuffix = Objects.requireNonNull(sortKeySuffix);
        }

        public DokumentLn1IdSupplier(@NonNull String sortKeyPrefix, int dokument) {
            this(sortKeyPrefix, dokument, "");
        }

        @Override
        public DokumentId supplyDokumentId(@NonNull RunContext runContext, @Nullable DMK rowDMK) {
            return new DokumentId(this.sortKeyPrefix, this.dokument, 1, this.sortKeySuffix);
        }
    }

    public static class NegativeIdSupplier
    implements DokumentIdSupplier {
        protected static final int DOKUMENT_AUTODETECT = -1;
        protected static final int LN_DOKUMENT_AUTODETECT = -1;
        private final @NonNull String sortKeyPrefix;
        private final @NonNull String sortKeySuffix;

        public NegativeIdSupplier() {
            this("", "");
        }

        public NegativeIdSupplier(@NonNull String sortKeyPrefix, @NonNull String sortKeySuffix) {
            this.sortKeyPrefix = Objects.requireNonNull(sortKeyPrefix);
            this.sortKeySuffix = Objects.requireNonNull(sortKeySuffix);
        }

        @Override
        public DokumentId supplyDokumentId(@NonNull RunContext runContext, @Nullable DMK rowDMK) {
            return new DokumentId(this.sortKeyPrefix, -1, -1, this.sortKeySuffix);
        }
    }

    public static class AlwaysEnabledSupplier
    implements EnabledSupplier {
        @Override
        public boolean isEnabled(@NonNull RunContext runContext, @NonNull DMK rowDMK) {
            return true;
        }
    }
}

