/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PdfValue {
    private final @Nullable Object value;
    private final @NonNull FieldType fieldType;

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("value", this.value).append("fieldType", (Object)this.fieldType).toString();
    }

    public PdfValue(@Nullable Object value) {
        this.value = value;
        this.fieldType = PdfValue.initalizeFieldType(this.value);
    }

    private static FieldType initalizeFieldType(@Nullable Object value) {
        FieldType fieldType = FieldType.UNKNOWN;
        if (value instanceof Date || value instanceof Calendar) {
            fieldType = FieldType.DATE;
        } else if (value instanceof String) {
            fieldType = FieldType.TEXT;
        } else if (value instanceof Number) {
            fieldType = FieldType.DECIMAL;
            if (value instanceof Long || value instanceof Integer) {
                fieldType = FieldType.INTEGER;
            }
        } else if (value instanceof Boolean) {
            fieldType = FieldType.BOOLEAN;
        }
        return fieldType;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public @NonNull FieldType getFieldType() {
        return this.fieldType;
    }

    public static enum FieldType {
        UNKNOWN,
        TEXT,
        INTEGER,
        INTEGER_PRINT_ZERO,
        DECIMAL,
        DECIMAL_PRINT_ZERO,
        DATE,
        YEAR,
        BOOLEAN;

    }
}

